/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSInputStream;

public class HttpRangeInputStream
extends FSInputStream {
    private static final int DEFAULT_BUFFER_SIZE_BYTES = 0x100000;
    private final String url;
    private final int bufferSize;
    private long start = Long.MAX_VALUE;
    private long pos;
    private long len = 0L;
    private byte[] rangeContent;
    private boolean closed;

    public HttpRangeInputStream(String url) throws IOException {
        this(url, 0x100000);
    }

    public HttpRangeInputStream(String url, int bufferSize) throws IOException {
        this.url = url;
        this.bufferSize = bufferSize;
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Range", "bytes=0-0");
        String contentRangeHeader = connection.getHeaderField("Content-Range");
        if (contentRangeHeader == null || !contentRangeHeader.startsWith("bytes 0-0/")) {
            return;
        }
        this.len = Long.parseLong(contentRangeHeader.substring("bytes 0-0/".length()));
    }

    private void updateInputStream(long targetPos) throws MalformedURLException, IOException {
        if (targetPos >= this.start && targetPos < this.start + (long)this.bufferSize) {
            return;
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod("GET");
        long rangeEnd = Math.min(targetPos + (long)this.bufferSize, this.len);
        connection.setRequestProperty("Range", "bytes=" + targetPos + "-" + rangeEnd);
        this.rangeContent = new byte[(int)(rangeEnd - targetPos)];
        try (InputStream inputStream = connection.getInputStream();){
            IOUtils.readFully((InputStream)inputStream, (byte[])this.rangeContent);
        }
        this.start = targetPos;
    }

    public synchronized void seek(long targetPos) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + targetPos);
        }
        this.pos = targetPos;
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.len - this.pos > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.max(this.len - this.pos, 0L);
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.pos >= this.len) {
            return -1;
        }
        this.updateInputStream(this.pos);
        int res = this.rangeContent[(int)(this.pos - this.start)] & 0xFF;
        ++this.pos;
        return res;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }
}

