/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.FSConfiguration;
import io.lakefs.clients.sdk.ApiClient;
import io.lakefs.clients.sdk.BranchesApi;
import io.lakefs.clients.sdk.ConfigApi;
import io.lakefs.clients.sdk.Configuration;
import io.lakefs.clients.sdk.InternalApi;
import io.lakefs.clients.sdk.ObjectsApi;
import io.lakefs.clients.sdk.RepositoriesApi;
import io.lakefs.clients.sdk.StagingApi;
import io.lakefs.clients.sdk.auth.HttpBasicAuth;
import java.io.IOException;

public class LakeFSClient {
    private static final String BASIC_AUTH = "basic_auth";
    private final ObjectsApi objectsApi;
    private final StagingApi stagingApi;
    private final RepositoriesApi repositoriesApi;
    private final BranchesApi branchesApi;
    private final ConfigApi configApi;
    private final InternalApi internalApi;

    public LakeFSClient(String scheme, org.apache.hadoop.conf.Configuration conf) throws IOException {
        String accessKey = FSConfiguration.get(conf, scheme, "access.key");
        if (accessKey == null) {
            throw new IOException("Missing lakeFS access key");
        }
        String secretKey = FSConfiguration.get(conf, scheme, "secret.key");
        if (secretKey == null) {
            throw new IOException("Missing lakeFS secret key");
        }
        ApiClient apiClient = Configuration.getDefaultApiClient();
        String endpoint = FSConfiguration.get(conf, scheme, "endpoint", "http://localhost:8000/api/v1");
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        apiClient.setBasePath(endpoint);
        apiClient.addDefaultHeader("X-Lakefs-Client", "lakefs-hadoopfs/" + this.getClass().getPackage().getImplementationVersion());
        HttpBasicAuth basicAuth = (HttpBasicAuth)apiClient.getAuthentication(BASIC_AUTH);
        basicAuth.setUsername(accessKey);
        basicAuth.setPassword(secretKey);
        String sessionId = FSConfiguration.get(conf, scheme, "session_id");
        if (sessionId != null) {
            apiClient.addDefaultCookie("sessionId", sessionId);
        }
        this.objectsApi = new ObjectsApi(apiClient);
        this.stagingApi = new StagingApi(apiClient);
        this.repositoriesApi = new RepositoriesApi(apiClient);
        this.branchesApi = new BranchesApi(apiClient);
        this.configApi = new ConfigApi(apiClient);
        this.internalApi = new InternalApi(apiClient);
    }

    public ObjectsApi getObjectsApi() {
        return this.objectsApi;
    }

    public StagingApi getStagingApi() {
        return this.stagingApi;
    }

    public RepositoriesApi getRepositoriesApi() {
        return this.repositoriesApi;
    }

    public BranchesApi getBranchesApi() {
        return this.branchesApi;
    }

    public ConfigApi getConfigApi() {
        return this.configApi;
    }

    public InternalApi getInternalApi() {
        return this.internalApi;
    }
}

