/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataClient {
    public static final Logger LOG = LoggerFactory.getLogger(MetadataClient.class);
    private final FileSystem fs;

    public MetadataClient(FileSystem fs) {
        if (fs == null) {
            throw new IllegalArgumentException();
        }
        this.fs = fs;
    }

    ObjectMetadata getObjectMetadata(URI physicalUri) throws IOException {
        String bucket = physicalUri.getHost();
        String key = physicalUri.getPath().substring(1);
        Path physicalPath = new Path(physicalUri.getPath());
        FileStatus fileStatus = this.fs.getFileStatus(physicalPath);
        try {
            Method getETagMethod = fileStatus.getClass().getMethod("getETag", new Class[0]);
            String etag = (String)getETagMethod.invoke((Object)fileStatus, new Object[0]);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(fileStatus.getLen());
            objectMetadata.setHeader("ETag", (Object)etag);
            return objectMetadata;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.debug("failed to get etag from file status", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Method amazonS3ClientGetter = this.fs.getClass().getDeclaredMethod("getAmazonS3Client", new Class[0]);
            amazonS3ClientGetter.setAccessible(true);
            Object s3Client = amazonS3ClientGetter.invoke((Object)this.fs, new Object[0]);
            Method getObjectMetadataMethod = s3Client.getClass().getDeclaredMethod("getObjectMetadata", GetObjectMetadataRequest.class);
            GetObjectMetadataRequest metadataRequest = new GetObjectMetadataRequest(bucket, key);
            return (ObjectMetadata)getObjectMetadataMethod.invoke(s3Client, metadataRequest);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("failed to get object metadata using underlying s3 client", (Throwable)e);
            try {
                Method fsGetter = this.fs.getClass().getDeclaredMethod("getWrappedFs", new Class[0]);
                Object s3fs = fsGetter.invoke((Object)this.fs, new Object[0]);
                Method amazonS3ClientGetter = s3fs.getClass().getDeclaredMethod("getAmazonS3Client", new Class[0]);
                amazonS3ClientGetter.setAccessible(true);
                Object s3Client = amazonS3ClientGetter.invoke(s3fs, new Object[0]);
                Method getObjectMetadataMethod = s3Client.getClass().getDeclaredMethod("getObjectMetadata", GetObjectMetadataRequest.class);
                GetObjectMetadataRequest metadataRequest = new GetObjectMetadataRequest(bucket, key);
                return (ObjectMetadata)getObjectMetadataMethod.invoke(s3Client, metadataRequest);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                LOG.warn("failed to get object metadata using underlying wrapped s3 client", (Throwable)e2);
                throw new IOException("get object metadata using underlying wrapped s3 client", e2);
            }
        }
    }
}

