/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.FSConfiguration;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.BranchesApi;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.ObjectsApi;
import io.lakefs.clients.api.RepositoriesApi;
import io.lakefs.clients.api.StagingApi;
import io.lakefs.clients.api.auth.HttpBasicAuth;
import java.io.IOException;

public class LakeFSClient {
    private static final String BASIC_AUTH = "basic_auth";
    private final ObjectsApi objects;
    private final StagingApi staging;
    private final RepositoriesApi repositories;
    private final BranchesApi branches;

    public LakeFSClient(String scheme, org.apache.hadoop.conf.Configuration conf) throws IOException {
        String accessKey = FSConfiguration.get(conf, scheme, "access.key");
        if (accessKey == null) {
            throw new IOException("Missing lakeFS access key");
        }
        String secretKey = FSConfiguration.get(conf, scheme, "secret.key");
        if (secretKey == null) {
            throw new IOException("Missing lakeFS secret key");
        }
        ApiClient apiClient = Configuration.getDefaultApiClient();
        String endpoint = FSConfiguration.get(conf, scheme, "endpoint", "http://localhost:8000/api/v1");
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        apiClient.setBasePath(endpoint);
        HttpBasicAuth basicAuth = (HttpBasicAuth)apiClient.getAuthentication(BASIC_AUTH);
        basicAuth.setUsername(accessKey);
        basicAuth.setPassword(secretKey);
        this.objects = new ObjectsApi(apiClient);
        this.staging = new StagingApi(apiClient);
        this.repositories = new RepositoriesApi(apiClient);
        this.branches = new BranchesApi(apiClient);
    }

    public ObjectsApi getObjects() {
        return this.objects;
    }

    public StagingApi getStaging() {
        return this.staging;
    }

    public RepositoriesApi getRepositories() {
        return this.repositories;
    }

    public BranchesApi getBranches() {
        return this.branches;
    }
}

