/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.utils;

import io.lakefs.utils.StringUtils;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.Path;

public class ObjectLocation {
    private String scheme;
    private String repository;
    private String ref;
    private String path;

    @Nonnull
    public static ObjectLocation pathToObjectLocation(Path workingDirectory, Path path) {
        if (!path.isAbsolute()) {
            if (workingDirectory == null) {
                throw new IllegalArgumentException(String.format("cannot expand local path %s with null workingDirectory", path));
            }
            path = new Path(workingDirectory, path);
        }
        URI uri = path.toUri();
        ObjectLocation loc = new ObjectLocation();
        loc.setScheme(uri.getScheme());
        loc.setRepository(uri.getHost());
        String s = StringUtils.trimLeadingSlash(uri.getPath());
        int i = s.indexOf("/");
        if (i == -1) {
            loc.setRef(s);
            loc.setPath("");
        } else {
            loc.setRef(s.substring(0, i));
            loc.setPath(s.substring(i + 1));
        }
        return loc;
    }

    @Nonnull
    public static ObjectLocation pathToObjectLocation(Path path) {
        return ObjectLocation.pathToObjectLocation(null, path);
    }

    public static String formatPath(String scheme, String repository, String ref, String path) {
        String ret = ObjectLocation.formatPath(scheme, repository, ref);
        if (path != null) {
            ret = ret + "/" + path;
        }
        return ret;
    }

    public static String formatPath(String scheme, String repository, String ref) {
        return String.format("%s://%s/%s", scheme, repository, ref);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ObjectLocation() {
    }

    public ObjectLocation(String scheme, String repository, String ref) {
        this.scheme = scheme;
        this.repository = repository;
        this.ref = ref;
    }

    public ObjectLocation(String scheme, String repository, String ref, String path) {
        this.scheme = scheme;
        this.repository = repository;
        this.ref = ref;
        this.path = path;
    }

    public ObjectLocation clone() {
        return new ObjectLocation(this.scheme, this.repository, this.ref, this.path);
    }

    public ObjectLocation getParent() {
        if (this.path == null) {
            return null;
        }
        Path parentPath = new Path(this.path).getParent();
        if (parentPath == null) {
            return null;
        }
        return new ObjectLocation(this.scheme, this.repository, this.ref, parentPath.toString());
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isValidPath() {
        return !this.repository.isEmpty() && !this.ref.isEmpty() && !this.path.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectLocation)) {
            return false;
        }
        ObjectLocation objLoc = (ObjectLocation)obj;
        return this.repository.equals(objLoc.getRepository()) && this.ref.equals(objLoc.getRef()) && this.path.equals(objLoc.getPath());
    }

    public boolean onSameBranch(ObjectLocation otherObjLoc) {
        return this.scheme.equals(otherObjLoc.getScheme()) && this.repository.equals(otherObjLoc.getRepository()) && this.ref.equals(otherObjLoc.getRef());
    }

    public String toString() {
        return ObjectLocation.formatPath(this.scheme, this.repository, this.ref, this.path);
    }

    public String toRefString() {
        return ObjectLocation.formatPath(this.scheme, this.repository, this.ref);
    }

    public ObjectLocation toDirectory() {
        return new ObjectLocation(this.scheme, this.repository, this.ref, StringUtils.addLeadingSlash(this.path));
    }

    public Path toFSPath() {
        return new Path(this.toString());
    }
}

