/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.storage;

import io.lakefs.LakeFSLinker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ObjectUtils;

public class LakeFSFileSystemOutputStream
extends OutputStream {
    private final HttpURLConnection connection;
    private final ByteArrayOutputStream buffer;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final LakeFSLinker linker;

    public LakeFSFileSystemOutputStream(HttpURLConnection connection, LakeFSLinker linker) throws IOException {
        this.connection = connection;
        this.buffer = new ByteArrayOutputStream();
        this.linker = linker;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        this.connection.setRequestProperty("Content-Length", String.valueOf(this.buffer.size()));
        this.connection.setRequestProperty("x-ms-blob-type", "BlockBlob");
        OutputStream out = this.connection.getOutputStream();
        out.write(this.buffer.toByteArray());
        out.close();
        String eTag = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.connection.getHeaderField("Content-MD5"), this.connection.getHeaderField("ETag")});
        this.linker.link(eTag, this.buffer.size());
        if (this.connection.getResponseCode() > 299) {
            throw new IOException("Failed to finish writing to presigned link. Response code: " + this.connection.getResponseCode());
        }
    }
}

