/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.FSConfiguration;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.BranchesApi;
import io.lakefs.clients.api.ConfigApi;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.ObjectsApi;
import io.lakefs.clients.api.RepositoriesApi;
import io.lakefs.clients.api.StagingApi;
import io.lakefs.clients.api.auth.HttpBasicAuth;
import java.io.IOException;

public class LakeFSClient {
    private static final String BASIC_AUTH = "basic_auth";
    private final ObjectsApi objectsApi;
    private final StagingApi stagingApi;
    private final RepositoriesApi repositoriesApi;
    private final BranchesApi branchesApi;
    private final ConfigApi configApi;

    public LakeFSClient(String scheme, org.apache.hadoop.conf.Configuration conf) throws IOException {
        String accessKey = FSConfiguration.get(conf, scheme, "access.key");
        if (accessKey == null) {
            throw new IOException("Missing lakeFS access key");
        }
        String secretKey = FSConfiguration.get(conf, scheme, "secret.key");
        if (secretKey == null) {
            throw new IOException("Missing lakeFS secret key");
        }
        ApiClient apiClient = Configuration.getDefaultApiClient();
        String endpoint = FSConfiguration.get(conf, scheme, "endpoint", "http://localhost:8000/api/v1");
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        apiClient.setBasePath(endpoint);
        apiClient.addDefaultHeader("X-Lakefs-Client", "lakefs-hadoopfs/" + this.getClass().getPackage().getImplementationVersion());
        HttpBasicAuth basicAuth = (HttpBasicAuth)apiClient.getAuthentication(BASIC_AUTH);
        basicAuth.setUsername(accessKey);
        basicAuth.setPassword(secretKey);
        this.objectsApi = new ObjectsApi(apiClient);
        this.stagingApi = new StagingApi(apiClient);
        this.repositoriesApi = new RepositoriesApi(apiClient);
        this.branchesApi = new BranchesApi(apiClient);
        this.configApi = new ConfigApi(apiClient);
    }

    public ObjectsApi getObjectsApi() {
        return this.objectsApi;
    }

    public StagingApi getStagingApi() {
        return this.stagingApi;
    }

    public RepositoriesApi getRepositoriesApi() {
        return this.repositoriesApi;
    }

    public BranchesApi getBranchesApi() {
        return this.branchesApi;
    }

    public ConfigApi getConfigApi() {
        return this.configApi;
    }
}

