/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.LakeFSFileSystem;
import io.lakefs.MetadataClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.model.StagingLocation;
import io.lakefs.utils.ObjectLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.Path;

class LinkOnCloseOutputStream
extends OutputStream {
    private final LakeFSFileSystem lfs;
    private final StagingLocation stagingLoc;
    private final ObjectLocation objectLoc;
    private final URI physicalUri;
    private final MetadataClient metadataClient;
    private final OutputStream out;
    private final AtomicBoolean isLinked = new AtomicBoolean(false);

    LinkOnCloseOutputStream(LakeFSFileSystem lfs, StagingLocation stagingLoc, ObjectLocation objectLoc, URI physicalUri, MetadataClient metadataClient, OutputStream out) {
        this.lfs = lfs;
        this.stagingLoc = stagingLoc;
        this.objectLoc = objectLoc;
        this.physicalUri = physicalUri;
        this.metadataClient = metadataClient;
        this.out = out;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (!this.isLinked.getAndSet(true)) {
            try {
                this.lfs.linkPhysicalAddress(this.objectLoc, this.stagingLoc, this.physicalUri, this.metadataClient);
            }
            catch (ApiException e) {
                throw new IOException("link lakeFS path to physical address", e);
            }
            this.lfs.deleteEmptyDirectoryMarkers(new Path(this.objectLoc.toString()).getParent());
        }
    }
}

