/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

class ObjectLocation {
    private String repository;
    private String ref;
    private String path;

    ObjectLocation() {
    }

    public static String formatPath(String repository, String ref, String path) {
        return String.format("%s://%s/%s/%s", "lakefs", repository, ref, path);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    static String trimLeadingSlash(String s) {
        if (s.startsWith("/")) {
            return s.substring(1);
        }
        return s;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectLocation)) {
            return false;
        }
        ObjectLocation objLoc = (ObjectLocation)obj;
        return this.repository.equals(objLoc.getRepository()) && this.ref.equals(objLoc.getRef()) && this.path.equals(objLoc.getPath());
    }

    public boolean onSameBranch(ObjectLocation otherObjLoc) {
        return this.repository.equals(otherObjLoc.getRepository()) && this.ref.equals(otherObjLoc.getRef());
    }

    public String toString() {
        return ObjectLocation.formatPath(this.repository, this.ref, this.path);
    }
}

