/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import io.lakefs.ObjectLocation;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.StagingApi;
import io.lakefs.clients.api.model.StagingLocation;
import io.lakefs.clients.api.model.StagingMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

class LinkOnCloseOutputStream
extends OutputStream {
    private AmazonS3 s3Client;
    private StagingApi staging;
    private StagingLocation stagingLoc;
    private ObjectLocation objectLoc;
    private URI physicalUri;
    private OutputStream out;

    LinkOnCloseOutputStream(AmazonS3 s3Client, StagingApi staging, StagingLocation stagingLoc, ObjectLocation objectLoc, URI physicalUri, OutputStream out) {
        this.s3Client = s3Client;
        this.staging = staging;
        this.stagingLoc = stagingLoc;
        this.objectLoc = objectLoc;
        this.physicalUri = physicalUri;
        this.out = out;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        String bucket = this.physicalUri.getHost();
        String key = ObjectLocation.trimLeadingSlash(this.physicalUri.getPath());
        ObjectMetadata objectMetadata = this.s3Client.getObjectMetadata(bucket, key);
        StagingMetadata metadata = new StagingMetadata().staging(this.stagingLoc).checksum(objectMetadata.getETag()).sizeBytes(Long.valueOf(objectMetadata.getContentLength()));
        try {
            this.staging.linkPhysicalAddress(this.objectLoc.getRepository(), this.objectLoc.getRef(), this.objectLoc.getPath(), metadata);
        }
        catch (ApiException e) {
            throw new IOException("link lakeFS path to physical address", e);
        }
    }
}

