/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs;

import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.ObjectsApi;
import io.lakefs.clients.api.RepositoriesApi;
import io.lakefs.clients.api.StagingApi;
import io.lakefs.clients.api.auth.HttpBasicAuth;
import java.io.IOException;

public class LakeFSClient {
    private static final String BASIC_AUTH = "basic_auth";
    private final ObjectsApi objects;
    private final StagingApi staging;
    private final RepositoriesApi repositories;

    public LakeFSClient(org.apache.hadoop.conf.Configuration conf) throws IOException {
        String accessKey = conf.get("fs.lakefs.access.key");
        if (accessKey == null) {
            throw new IOException("Missing lakeFS access key");
        }
        String secretKey = conf.get("fs.lakefs.secret.key");
        if (secretKey == null) {
            throw new IOException("Missing lakeFS secret key");
        }
        ApiClient apiClient = Configuration.getDefaultApiClient();
        String endpoint = conf.get("fs.lakefs.endpoint", "http://localhost:8000/api/v1");
        apiClient.setBasePath(endpoint);
        HttpBasicAuth basicAuth = (HttpBasicAuth)apiClient.getAuthentication(BASIC_AUTH);
        basicAuth.setUsername(accessKey);
        basicAuth.setPassword(secretKey);
        this.objects = new ObjectsApi(apiClient);
        this.staging = new StagingApi(apiClient);
        this.repositories = new RepositoriesApi(apiClient);
    }

    public ObjectsApi getObjects() {
        return this.objects;
    }

    public StagingApi getStaging() {
        return this.staging;
    }

    public RepositoriesApi getRepositories() {
        return this.repositories;
    }
}

