/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.lakefs.clients.api.model.UploadPart;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompletePresignMultipartUpload {
    public static final String SERIALIZED_NAME_PHYSICAL_ADDRESS = "physical_address";
    @SerializedName(value="physical_address")
    private String physicalAddress;
    public static final String SERIALIZED_NAME_PARTS = "parts";
    @SerializedName(value="parts")
    private List<UploadPart> parts = new ArrayList<UploadPart>();
    public static final String SERIALIZED_NAME_USER_METADATA = "user_metadata";
    @SerializedName(value="user_metadata")
    private Map<String, String> userMetadata = null;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;

    public CompletePresignMultipartUpload physicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public CompletePresignMultipartUpload parts(List<UploadPart> parts) {
        this.parts = parts;
        return this;
    }

    public CompletePresignMultipartUpload addPartsItem(UploadPart partsItem) {
        this.parts.add(partsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of uploaded parts, should be ordered by ascending part number")
    public List<UploadPart> getParts() {
        return this.parts;
    }

    public void setParts(List<UploadPart> parts) {
        this.parts = parts;
    }

    public CompletePresignMultipartUpload userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public CompletePresignMultipartUpload putUserMetadataItem(String key, String userMetadataItem) {
        if (this.userMetadata == null) {
            this.userMetadata = new HashMap<String, String>();
        }
        this.userMetadata.put(key, userMetadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public CompletePresignMultipartUpload contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Object media type")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletePresignMultipartUpload completePresignMultipartUpload = (CompletePresignMultipartUpload)o;
        return Objects.equals(this.physicalAddress, completePresignMultipartUpload.physicalAddress) && Objects.equals(this.parts, completePresignMultipartUpload.parts) && Objects.equals(this.userMetadata, completePresignMultipartUpload.userMetadata) && Objects.equals(this.contentType, completePresignMultipartUpload.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.physicalAddress, this.parts, this.userMetadata, this.contentType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompletePresignMultipartUpload {\n");
        sb.append("    physicalAddress: ").append(this.toIndentedString(this.physicalAddress)).append("\n");
        sb.append("    parts: ").append(this.toIndentedString(this.parts)).append("\n");
        sb.append("    userMetadata: ").append(this.toIndentedString(this.userMetadata)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

