/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.AuthCapabilities;
import io.lakefs.clients.api.model.BranchProtectionRule;
import io.lakefs.clients.api.model.CommPrefsInput;
import io.lakefs.clients.api.model.CredentialsWithSecret;
import io.lakefs.clients.api.model.GarbageCollectionConfig;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.api.model.GarbageCollectionRules;
import io.lakefs.clients.api.model.InlineObject1;
import io.lakefs.clients.api.model.InstallationUsageReport;
import io.lakefs.clients.api.model.ObjectStageCreation;
import io.lakefs.clients.api.model.ObjectStats;
import io.lakefs.clients.api.model.PrepareGCUncommittedRequest;
import io.lakefs.clients.api.model.PrepareGCUncommittedResponse;
import io.lakefs.clients.api.model.RefsDump;
import io.lakefs.clients.api.model.RefsRestore;
import io.lakefs.clients.api.model.RepositoryMetadataKeys;
import io.lakefs.clients.api.model.RepositoryMetadataSet;
import io.lakefs.clients.api.model.Setup;
import io.lakefs.clients.api.model.SetupState;
import io.lakefs.clients.api.model.StatsEventsList;
import io.lakefs.clients.api.model.StorageConfig;
import io.lakefs.clients.api.model.StorageURI;
import io.lakefs.clients.api.model.VersionConfig;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class InternalApi {
    private ApiClient localVarApiClient;

    public InternalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InternalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createBranchProtectionRulePreflightCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branch_protection/set_allowed".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBranchProtectionRulePreflightValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createBranchProtectionRulePreflight(Async)");
        }
        Call localVarCall = this.createBranchProtectionRulePreflightCall(repository, _callback);
        return localVarCall;
    }

    public void createBranchProtectionRulePreflight(String repository) throws ApiException {
        this.createBranchProtectionRulePreflightWithHttpInfo(repository);
    }

    public ApiResponse<Void> createBranchProtectionRulePreflightWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.createBranchProtectionRulePreflightValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBranchProtectionRulePreflightAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBranchProtectionRulePreflightValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createSymlinkFileCall(String repository, String branch, String location, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{branch}/symlink".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (location != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("location", location));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSymlinkFileValidateBeforeCall(String repository, String branch, String location, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createSymlinkFile(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createSymlinkFile(Async)");
        }
        Call localVarCall = this.createSymlinkFileCall(repository, branch, location, _callback);
        return localVarCall;
    }

    public StorageURI createSymlinkFile(String repository, String branch, String location) throws ApiException {
        ApiResponse<StorageURI> localVarResp = this.createSymlinkFileWithHttpInfo(repository, branch, location);
        return localVarResp.getData();
    }

    public ApiResponse<StorageURI> createSymlinkFileWithHttpInfo(String repository, String branch, String location) throws ApiException {
        Call localVarCall = this.createSymlinkFileValidateBeforeCall(repository, branch, location, null);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSymlinkFileAsync(String repository, String branch, String location, ApiCallback<StorageURI> _callback) throws ApiException {
        Call localVarCall = this.createSymlinkFileValidateBeforeCall(repository, branch, location, _callback);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteRepositoryMetadataCall(String repository, RepositoryMetadataKeys repositoryMetadataKeys, ApiCallback _callback) throws ApiException {
        RepositoryMetadataKeys localVarPostBody = repositoryMetadataKeys;
        String localVarPath = "/repositories/{repository}/metadata".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRepositoryMetadataValidateBeforeCall(String repository, RepositoryMetadataKeys repositoryMetadataKeys, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteRepositoryMetadata(Async)");
        }
        if (repositoryMetadataKeys == null) {
            throw new ApiException("Missing the required parameter 'repositoryMetadataKeys' when calling deleteRepositoryMetadata(Async)");
        }
        Call localVarCall = this.deleteRepositoryMetadataCall(repository, repositoryMetadataKeys, _callback);
        return localVarCall;
    }

    public void deleteRepositoryMetadata(String repository, RepositoryMetadataKeys repositoryMetadataKeys) throws ApiException {
        this.deleteRepositoryMetadataWithHttpInfo(repository, repositoryMetadataKeys);
    }

    public ApiResponse<Void> deleteRepositoryMetadataWithHttpInfo(String repository, RepositoryMetadataKeys repositoryMetadataKeys) throws ApiException {
        Call localVarCall = this.deleteRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataKeys, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRepositoryMetadataAsync(String repository, RepositoryMetadataKeys repositoryMetadataKeys, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataKeys, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call dumpRefsCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/dump".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dumpRefsValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling dumpRefs(Async)");
        }
        Call localVarCall = this.dumpRefsCall(repository, _callback);
        return localVarCall;
    }

    public RefsDump dumpRefs(String repository) throws ApiException {
        ApiResponse<RefsDump> localVarResp = this.dumpRefsWithHttpInfo(repository);
        return localVarResp.getData();
    }

    public ApiResponse<RefsDump> dumpRefsWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.dumpRefsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<RefsDump>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call dumpRefsAsync(String repository, ApiCallback<RefsDump> _callback) throws ApiException {
        Call localVarCall = this.dumpRefsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<RefsDump>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAuthCapabilitiesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/auth/capabilities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuthCapabilitiesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesCall(_callback);
        return localVarCall;
    }

    public AuthCapabilities getAuthCapabilities() throws ApiException {
        ApiResponse<AuthCapabilities> localVarResp = this.getAuthCapabilitiesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<AuthCapabilities> getAuthCapabilitiesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AuthCapabilities>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAuthCapabilitiesAsync(ApiCallback<AuthCapabilities> _callback) throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AuthCapabilities>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGarbageCollectionConfigCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/config/garbage-collection";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGarbageCollectionConfigValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getGarbageCollectionConfigCall(_callback);
        return localVarCall;
    }

    public GarbageCollectionConfig getGarbageCollectionConfig() throws ApiException {
        ApiResponse<GarbageCollectionConfig> localVarResp = this.getGarbageCollectionConfigWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<GarbageCollectionConfig> getGarbageCollectionConfigWithHttpInfo() throws ApiException {
        Call localVarCall = this.getGarbageCollectionConfigValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GarbageCollectionConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGarbageCollectionConfigAsync(ApiCallback<GarbageCollectionConfig> _callback) throws ApiException {
        Call localVarCall = this.getGarbageCollectionConfigValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call getLakeFSVersionCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/config/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getLakeFSVersionValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getLakeFSVersionCall(_callback);
        return localVarCall;
    }

    @Deprecated
    public VersionConfig getLakeFSVersion() throws ApiException {
        ApiResponse<VersionConfig> localVarResp = this.getLakeFSVersionWithHttpInfo();
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<VersionConfig> getLakeFSVersionWithHttpInfo() throws ApiException {
        Call localVarCall = this.getLakeFSVersionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<VersionConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call getLakeFSVersionAsync(ApiCallback<VersionConfig> _callback) throws ApiException {
        Call localVarCall = this.getLakeFSVersionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<VersionConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSetupStateCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/setup_lakefs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSetupStateValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getSetupStateCall(_callback);
        return localVarCall;
    }

    public SetupState getSetupState() throws ApiException {
        ApiResponse<SetupState> localVarResp = this.getSetupStateWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<SetupState> getSetupStateWithHttpInfo() throws ApiException {
        Call localVarCall = this.getSetupStateValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SetupState>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSetupStateAsync(ApiCallback<SetupState> _callback) throws ApiException {
        Call localVarCall = this.getSetupStateValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SetupState>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call getStorageConfigCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/config/storage";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getStorageConfigValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getStorageConfigCall(_callback);
        return localVarCall;
    }

    @Deprecated
    public StorageConfig getStorageConfig() throws ApiException {
        ApiResponse<StorageConfig> localVarResp = this.getStorageConfigWithHttpInfo();
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<StorageConfig> getStorageConfigWithHttpInfo() throws ApiException {
        Call localVarCall = this.getStorageConfigValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<StorageConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call getStorageConfigAsync(ApiCallback<StorageConfig> _callback) throws ApiException {
        Call localVarCall = this.getStorageConfigValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<StorageConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUsageReportSummaryCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/usage-report/summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/text"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsageReportSummaryValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUsageReportSummaryCall(_callback);
        return localVarCall;
    }

    public InstallationUsageReport getUsageReportSummary() throws ApiException {
        ApiResponse<InstallationUsageReport> localVarResp = this.getUsageReportSummaryWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<InstallationUsageReport> getUsageReportSummaryWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUsageReportSummaryValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<InstallationUsageReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUsageReportSummaryAsync(ApiCallback<InstallationUsageReport> _callback) throws ApiException {
        Call localVarCall = this.getUsageReportSummaryValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<InstallationUsageReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call internalCreateBranchProtectionRuleCall(String repository, BranchProtectionRule branchProtectionRule, ApiCallback _callback) throws ApiException {
        BranchProtectionRule localVarPostBody = branchProtectionRule;
        String localVarPath = "/repositories/{repository}/branch_protection".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalCreateBranchProtectionRuleValidateBeforeCall(String repository, BranchProtectionRule branchProtectionRule, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalCreateBranchProtectionRule(Async)");
        }
        if (branchProtectionRule == null) {
            throw new ApiException("Missing the required parameter 'branchProtectionRule' when calling internalCreateBranchProtectionRule(Async)");
        }
        Call localVarCall = this.internalCreateBranchProtectionRuleCall(repository, branchProtectionRule, _callback);
        return localVarCall;
    }

    @Deprecated
    public void internalCreateBranchProtectionRule(String repository, BranchProtectionRule branchProtectionRule) throws ApiException {
        this.internalCreateBranchProtectionRuleWithHttpInfo(repository, branchProtectionRule);
    }

    @Deprecated
    public ApiResponse<Void> internalCreateBranchProtectionRuleWithHttpInfo(String repository, BranchProtectionRule branchProtectionRule) throws ApiException {
        Call localVarCall = this.internalCreateBranchProtectionRuleValidateBeforeCall(repository, branchProtectionRule, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    @Deprecated
    public Call internalCreateBranchProtectionRuleAsync(String repository, BranchProtectionRule branchProtectionRule, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalCreateBranchProtectionRuleValidateBeforeCall(repository, branchProtectionRule, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call internalDeleteBranchProtectionRuleCall(String repository, InlineObject1 inlineObject1, ApiCallback _callback) throws ApiException {
        InlineObject1 localVarPostBody = inlineObject1;
        String localVarPath = "/repositories/{repository}/branch_protection".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalDeleteBranchProtectionRuleValidateBeforeCall(String repository, InlineObject1 inlineObject1, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalDeleteBranchProtectionRule(Async)");
        }
        if (inlineObject1 == null) {
            throw new ApiException("Missing the required parameter 'inlineObject1' when calling internalDeleteBranchProtectionRule(Async)");
        }
        Call localVarCall = this.internalDeleteBranchProtectionRuleCall(repository, inlineObject1, _callback);
        return localVarCall;
    }

    @Deprecated
    public void internalDeleteBranchProtectionRule(String repository, InlineObject1 inlineObject1) throws ApiException {
        this.internalDeleteBranchProtectionRuleWithHttpInfo(repository, inlineObject1);
    }

    @Deprecated
    public ApiResponse<Void> internalDeleteBranchProtectionRuleWithHttpInfo(String repository, InlineObject1 inlineObject1) throws ApiException {
        Call localVarCall = this.internalDeleteBranchProtectionRuleValidateBeforeCall(repository, inlineObject1, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    @Deprecated
    public Call internalDeleteBranchProtectionRuleAsync(String repository, InlineObject1 inlineObject1, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalDeleteBranchProtectionRuleValidateBeforeCall(repository, inlineObject1, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call internalDeleteGarbageCollectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/rules".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalDeleteGarbageCollectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalDeleteGarbageCollectionRules(Async)");
        }
        Call localVarCall = this.internalDeleteGarbageCollectionRulesCall(repository, _callback);
        return localVarCall;
    }

    @Deprecated
    public void internalDeleteGarbageCollectionRules(String repository) throws ApiException {
        this.internalDeleteGarbageCollectionRulesWithHttpInfo(repository);
    }

    @Deprecated
    public ApiResponse<Void> internalDeleteGarbageCollectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.internalDeleteGarbageCollectionRulesValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    @Deprecated
    public Call internalDeleteGarbageCollectionRulesAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalDeleteGarbageCollectionRulesValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call internalGetBranchProtectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branch_protection".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalGetBranchProtectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalGetBranchProtectionRules(Async)");
        }
        Call localVarCall = this.internalGetBranchProtectionRulesCall(repository, _callback);
        return localVarCall;
    }

    @Deprecated
    public List<BranchProtectionRule> internalGetBranchProtectionRules(String repository) throws ApiException {
        ApiResponse<List<BranchProtectionRule>> localVarResp = this.internalGetBranchProtectionRulesWithHttpInfo(repository);
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<List<BranchProtectionRule>> internalGetBranchProtectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.internalGetBranchProtectionRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call internalGetBranchProtectionRulesAsync(String repository, ApiCallback<List<BranchProtectionRule>> _callback) throws ApiException {
        Call localVarCall = this.internalGetBranchProtectionRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call internalGetGarbageCollectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/rules".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalGetGarbageCollectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalGetGarbageCollectionRules(Async)");
        }
        Call localVarCall = this.internalGetGarbageCollectionRulesCall(repository, _callback);
        return localVarCall;
    }

    @Deprecated
    public GarbageCollectionRules internalGetGarbageCollectionRules(String repository) throws ApiException {
        ApiResponse<GarbageCollectionRules> localVarResp = this.internalGetGarbageCollectionRulesWithHttpInfo(repository);
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<GarbageCollectionRules> internalGetGarbageCollectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.internalGetGarbageCollectionRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionRules>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call internalGetGarbageCollectionRulesAsync(String repository, ApiCallback<GarbageCollectionRules> _callback) throws ApiException {
        Call localVarCall = this.internalGetGarbageCollectionRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionRules>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call internalSetGarbageCollectionRulesCall(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback _callback) throws ApiException {
        GarbageCollectionRules localVarPostBody = garbageCollectionRules;
        String localVarPath = "/repositories/{repository}/gc/rules".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call internalSetGarbageCollectionRulesValidateBeforeCall(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling internalSetGarbageCollectionRules(Async)");
        }
        if (garbageCollectionRules == null) {
            throw new ApiException("Missing the required parameter 'garbageCollectionRules' when calling internalSetGarbageCollectionRules(Async)");
        }
        Call localVarCall = this.internalSetGarbageCollectionRulesCall(repository, garbageCollectionRules, _callback);
        return localVarCall;
    }

    @Deprecated
    public void internalSetGarbageCollectionRules(String repository, GarbageCollectionRules garbageCollectionRules) throws ApiException {
        this.internalSetGarbageCollectionRulesWithHttpInfo(repository, garbageCollectionRules);
    }

    @Deprecated
    public ApiResponse<Void> internalSetGarbageCollectionRulesWithHttpInfo(String repository, GarbageCollectionRules garbageCollectionRules) throws ApiException {
        Call localVarCall = this.internalSetGarbageCollectionRulesValidateBeforeCall(repository, garbageCollectionRules, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    @Deprecated
    public Call internalSetGarbageCollectionRulesAsync(String repository, GarbageCollectionRules garbageCollectionRules, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.internalSetGarbageCollectionRulesValidateBeforeCall(repository, garbageCollectionRules, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call postStatsEventsCall(StatsEventsList statsEventsList, ApiCallback _callback) throws ApiException {
        StatsEventsList localVarPostBody = statsEventsList;
        String localVarPath = "/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postStatsEventsValidateBeforeCall(StatsEventsList statsEventsList, ApiCallback _callback) throws ApiException {
        if (statsEventsList == null) {
            throw new ApiException("Missing the required parameter 'statsEventsList' when calling postStatsEvents(Async)");
        }
        Call localVarCall = this.postStatsEventsCall(statsEventsList, _callback);
        return localVarCall;
    }

    public void postStatsEvents(StatsEventsList statsEventsList) throws ApiException {
        this.postStatsEventsWithHttpInfo(statsEventsList);
    }

    public ApiResponse<Void> postStatsEventsWithHttpInfo(StatsEventsList statsEventsList) throws ApiException {
        Call localVarCall = this.postStatsEventsValidateBeforeCall(statsEventsList, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call postStatsEventsAsync(StatsEventsList statsEventsList, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postStatsEventsValidateBeforeCall(statsEventsList, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call prepareGarbageCollectionCommitsCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/prepare_commits".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prepareGarbageCollectionCommitsValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionCommits(Async)");
        }
        Call localVarCall = this.prepareGarbageCollectionCommitsCall(repository, _callback);
        return localVarCall;
    }

    public GarbageCollectionPrepareResponse prepareGarbageCollectionCommits(String repository) throws ApiException {
        ApiResponse<GarbageCollectionPrepareResponse> localVarResp = this.prepareGarbageCollectionCommitsWithHttpInfo(repository);
        return localVarResp.getData();
    }

    public ApiResponse<GarbageCollectionPrepareResponse> prepareGarbageCollectionCommitsWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionCommitsValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call prepareGarbageCollectionCommitsAsync(String repository, ApiCallback<GarbageCollectionPrepareResponse> _callback) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionCommitsValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<GarbageCollectionPrepareResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call prepareGarbageCollectionUncommittedCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback _callback) throws ApiException {
        PrepareGCUncommittedRequest localVarPostBody = prepareGCUncommittedRequest;
        String localVarPath = "/repositories/{repository}/gc/prepare_uncommited".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prepareGarbageCollectionUncommittedValidateBeforeCall(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling prepareGarbageCollectionUncommitted(Async)");
        }
        Call localVarCall = this.prepareGarbageCollectionUncommittedCall(repository, prepareGCUncommittedRequest, _callback);
        return localVarCall;
    }

    public PrepareGCUncommittedResponse prepareGarbageCollectionUncommitted(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        ApiResponse<PrepareGCUncommittedResponse> localVarResp = this.prepareGarbageCollectionUncommittedWithHttpInfo(repository, prepareGCUncommittedRequest);
        return localVarResp.getData();
    }

    public ApiResponse<PrepareGCUncommittedResponse> prepareGarbageCollectionUncommittedWithHttpInfo(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, null);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call prepareGarbageCollectionUncommittedAsync(String repository, PrepareGCUncommittedRequest prepareGCUncommittedRequest, ApiCallback<PrepareGCUncommittedResponse> _callback) throws ApiException {
        Call localVarCall = this.prepareGarbageCollectionUncommittedValidateBeforeCall(repository, prepareGCUncommittedRequest, _callback);
        Type localVarReturnType = new TypeToken<PrepareGCUncommittedResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call restoreRefsCall(String repository, RefsRestore refsRestore, ApiCallback _callback) throws ApiException {
        RefsRestore localVarPostBody = refsRestore;
        String localVarPath = "/repositories/{repository}/refs/restore".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restoreRefsValidateBeforeCall(String repository, RefsRestore refsRestore, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling restoreRefs(Async)");
        }
        if (refsRestore == null) {
            throw new ApiException("Missing the required parameter 'refsRestore' when calling restoreRefs(Async)");
        }
        Call localVarCall = this.restoreRefsCall(repository, refsRestore, _callback);
        return localVarCall;
    }

    public void restoreRefs(String repository, RefsRestore refsRestore) throws ApiException {
        this.restoreRefsWithHttpInfo(repository, refsRestore);
    }

    public ApiResponse<Void> restoreRefsWithHttpInfo(String repository, RefsRestore refsRestore) throws ApiException {
        Call localVarCall = this.restoreRefsValidateBeforeCall(repository, refsRestore, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restoreRefsAsync(String repository, RefsRestore refsRestore, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restoreRefsValidateBeforeCall(repository, refsRestore, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setGarbageCollectionRulesPreflightCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/gc/rules/set_allowed".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setGarbageCollectionRulesPreflightValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling setGarbageCollectionRulesPreflight(Async)");
        }
        Call localVarCall = this.setGarbageCollectionRulesPreflightCall(repository, _callback);
        return localVarCall;
    }

    public void setGarbageCollectionRulesPreflight(String repository) throws ApiException {
        this.setGarbageCollectionRulesPreflightWithHttpInfo(repository);
    }

    public ApiResponse<Void> setGarbageCollectionRulesPreflightWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.setGarbageCollectionRulesPreflightValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setGarbageCollectionRulesPreflightAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setGarbageCollectionRulesPreflightValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setRepositoryMetadataCall(String repository, RepositoryMetadataSet repositoryMetadataSet, ApiCallback _callback) throws ApiException {
        RepositoryMetadataSet localVarPostBody = repositoryMetadataSet;
        String localVarPath = "/repositories/{repository}/metadata".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setRepositoryMetadataValidateBeforeCall(String repository, RepositoryMetadataSet repositoryMetadataSet, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling setRepositoryMetadata(Async)");
        }
        if (repositoryMetadataSet == null) {
            throw new ApiException("Missing the required parameter 'repositoryMetadataSet' when calling setRepositoryMetadata(Async)");
        }
        Call localVarCall = this.setRepositoryMetadataCall(repository, repositoryMetadataSet, _callback);
        return localVarCall;
    }

    public void setRepositoryMetadata(String repository, RepositoryMetadataSet repositoryMetadataSet) throws ApiException {
        this.setRepositoryMetadataWithHttpInfo(repository, repositoryMetadataSet);
    }

    public ApiResponse<Void> setRepositoryMetadataWithHttpInfo(String repository, RepositoryMetadataSet repositoryMetadataSet) throws ApiException {
        Call localVarCall = this.setRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataSet, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setRepositoryMetadataAsync(String repository, RepositoryMetadataSet repositoryMetadataSet, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setRepositoryMetadataValidateBeforeCall(repository, repositoryMetadataSet, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setupCall(Setup setup, ApiCallback _callback) throws ApiException {
        Setup localVarPostBody = setup;
        String localVarPath = "/setup_lakefs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setupValidateBeforeCall(Setup setup, ApiCallback _callback) throws ApiException {
        if (setup == null) {
            throw new ApiException("Missing the required parameter 'setup' when calling setup(Async)");
        }
        Call localVarCall = this.setupCall(setup, _callback);
        return localVarCall;
    }

    public CredentialsWithSecret setup(Setup setup) throws ApiException {
        ApiResponse<CredentialsWithSecret> localVarResp = this.setupWithHttpInfo(setup);
        return localVarResp.getData();
    }

    public ApiResponse<CredentialsWithSecret> setupWithHttpInfo(Setup setup) throws ApiException {
        Call localVarCall = this.setupValidateBeforeCall(setup, null);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setupAsync(Setup setup, ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
        Call localVarCall = this.setupValidateBeforeCall(setup, _callback);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setupCommPrefsCall(CommPrefsInput commPrefsInput, ApiCallback _callback) throws ApiException {
        CommPrefsInput localVarPostBody = commPrefsInput;
        String localVarPath = "/setup_comm_prefs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setupCommPrefsValidateBeforeCall(CommPrefsInput commPrefsInput, ApiCallback _callback) throws ApiException {
        if (commPrefsInput == null) {
            throw new ApiException("Missing the required parameter 'commPrefsInput' when calling setupCommPrefs(Async)");
        }
        Call localVarCall = this.setupCommPrefsCall(commPrefsInput, _callback);
        return localVarCall;
    }

    public void setupCommPrefs(CommPrefsInput commPrefsInput) throws ApiException {
        this.setupCommPrefsWithHttpInfo(commPrefsInput);
    }

    public ApiResponse<Void> setupCommPrefsWithHttpInfo(CommPrefsInput commPrefsInput) throws ApiException {
        Call localVarCall = this.setupCommPrefsValidateBeforeCall(commPrefsInput, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setupCommPrefsAsync(CommPrefsInput commPrefsInput, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setupCommPrefsValidateBeforeCall(commPrefsInput, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call stageObjectCall(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        ObjectStageCreation localVarPostBody = objectStageCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call stageObjectValidateBeforeCall(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling stageObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling stageObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling stageObject(Async)");
        }
        if (objectStageCreation == null) {
            throw new ApiException("Missing the required parameter 'objectStageCreation' when calling stageObject(Async)");
        }
        Call localVarCall = this.stageObjectCall(repository, branch, path, objectStageCreation, _callback);
        return localVarCall;
    }

    @Deprecated
    public ObjectStats stageObject(String repository, String branch, String path, ObjectStageCreation objectStageCreation) throws ApiException {
        ApiResponse<ObjectStats> localVarResp = this.stageObjectWithHttpInfo(repository, branch, path, objectStageCreation);
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<ObjectStats> stageObjectWithHttpInfo(String repository, String branch, String path, ObjectStageCreation objectStageCreation) throws ApiException {
        Call localVarCall = this.stageObjectValidateBeforeCall(repository, branch, path, objectStageCreation, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call stageObjectAsync(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.stageObjectValidateBeforeCall(repository, branch, path, objectStageCreation, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadObjectPreflightCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects/stage_allowed".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadObjectPreflightValidateBeforeCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling uploadObjectPreflight(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling uploadObjectPreflight(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling uploadObjectPreflight(Async)");
        }
        Call localVarCall = this.uploadObjectPreflightCall(repository, branch, path, _callback);
        return localVarCall;
    }

    public void uploadObjectPreflight(String repository, String branch, String path) throws ApiException {
        this.uploadObjectPreflightWithHttpInfo(repository, branch, path);
    }

    public ApiResponse<Void> uploadObjectPreflightWithHttpInfo(String repository, String branch, String path) throws ApiException {
        Call localVarCall = this.uploadObjectPreflightValidateBeforeCall(repository, branch, path, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call uploadObjectPreflightAsync(String repository, String branch, String path, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.uploadObjectPreflightValidateBeforeCall(repository, branch, path, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

