/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.AbortPresignMultipartUpload;
import io.lakefs.clients.api.model.CompletePresignMultipartUpload;
import io.lakefs.clients.api.model.OTFDiffs;
import io.lakefs.clients.api.model.ObjectStats;
import io.lakefs.clients.api.model.OtfDiffList;
import io.lakefs.clients.api.model.PresignMultipartUpload;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExperimentalApi {
    private ApiClient localVarApiClient;

    public ExperimentalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call abortPresignMultipartUploadCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        AbortPresignMultipartUpload localVarPostBody = abortPresignMultipartUpload;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString())).replaceAll("\\{uploadId\\}", this.localVarApiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call abortPresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling abortPresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling abortPresignMultipartUpload(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling abortPresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling abortPresignMultipartUpload(Async)");
        }
        Call localVarCall = this.abortPresignMultipartUploadCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        return localVarCall;
    }

    public void abortPresignMultipartUpload(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload) throws ApiException {
        this.abortPresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, abortPresignMultipartUpload);
    }

    public ApiResponse<Void> abortPresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload) throws ApiException {
        Call localVarCall = this.abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call abortPresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, AbortPresignMultipartUpload abortPresignMultipartUpload, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.abortPresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, abortPresignMultipartUpload, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call completePresignMultipartUploadCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        CompletePresignMultipartUpload localVarPostBody = completePresignMultipartUpload;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu/{uploadId}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString())).replaceAll("\\{uploadId\\}", this.localVarApiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call completePresignMultipartUploadValidateBeforeCall(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling completePresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling completePresignMultipartUpload(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling completePresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling completePresignMultipartUpload(Async)");
        }
        Call localVarCall = this.completePresignMultipartUploadCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        return localVarCall;
    }

    public ObjectStats completePresignMultipartUpload(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload) throws ApiException {
        ApiResponse<ObjectStats> localVarResp = this.completePresignMultipartUploadWithHttpInfo(repository, branch, uploadId, path, completePresignMultipartUpload);
        return localVarResp.getData();
    }

    public ApiResponse<ObjectStats> completePresignMultipartUploadWithHttpInfo(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload) throws ApiException {
        Call localVarCall = this.completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call completePresignMultipartUploadAsync(String repository, String branch, String uploadId, String path, CompletePresignMultipartUpload completePresignMultipartUpload, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.completePresignMultipartUploadValidateBeforeCall(repository, branch, uploadId, path, completePresignMultipartUpload, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createPresignMultipartUploadCall(String repository, String branch, String path, Integer parts, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/staging/pmpu".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (parts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parts", parts));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPresignMultipartUploadValidateBeforeCall(String repository, String branch, String path, Integer parts, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createPresignMultipartUpload(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling createPresignMultipartUpload(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling createPresignMultipartUpload(Async)");
        }
        Call localVarCall = this.createPresignMultipartUploadCall(repository, branch, path, parts, _callback);
        return localVarCall;
    }

    public PresignMultipartUpload createPresignMultipartUpload(String repository, String branch, String path, Integer parts) throws ApiException {
        ApiResponse<PresignMultipartUpload> localVarResp = this.createPresignMultipartUploadWithHttpInfo(repository, branch, path, parts);
        return localVarResp.getData();
    }

    public ApiResponse<PresignMultipartUpload> createPresignMultipartUploadWithHttpInfo(String repository, String branch, String path, Integer parts) throws ApiException {
        Call localVarCall = this.createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, null);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPresignMultipartUploadAsync(String repository, String branch, String path, Integer parts, ApiCallback<PresignMultipartUpload> _callback) throws ApiException {
        Call localVarCall = this.createPresignMultipartUploadValidateBeforeCall(repository, branch, path, parts, _callback);
        Type localVarReturnType = new TypeToken<PresignMultipartUpload>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOtfDiffsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/otf/diffs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOtfDiffsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getOtfDiffsCall(_callback);
        return localVarCall;
    }

    public OTFDiffs getOtfDiffs() throws ApiException {
        ApiResponse<OTFDiffs> localVarResp = this.getOtfDiffsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<OTFDiffs> getOtfDiffsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getOtfDiffsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<OTFDiffs>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOtfDiffsAsync(ApiCallback<OTFDiffs> _callback) throws ApiException {
        Call localVarCall = this.getOtfDiffsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<OTFDiffs>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call hardResetBranchCall(String repository, String branch, String ref, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/hard_reset".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ref != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ref", ref));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call hardResetBranchValidateBeforeCall(String repository, String branch, String ref, Boolean force, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling hardResetBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling hardResetBranch(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling hardResetBranch(Async)");
        }
        Call localVarCall = this.hardResetBranchCall(repository, branch, ref, force, _callback);
        return localVarCall;
    }

    public void hardResetBranch(String repository, String branch, String ref, Boolean force) throws ApiException {
        this.hardResetBranchWithHttpInfo(repository, branch, ref, force);
    }

    public ApiResponse<Void> hardResetBranchWithHttpInfo(String repository, String branch, String ref, Boolean force) throws ApiException {
        Call localVarCall = this.hardResetBranchValidateBeforeCall(repository, branch, ref, force, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call hardResetBranchAsync(String repository, String branch, String ref, Boolean force, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.hardResetBranchValidateBeforeCall(repository, branch, ref, force, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call otfDiffCall(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/otf/refs/{left_ref}/diff/{right_ref}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{left_ref\\}", this.localVarApiClient.escapeString(leftRef.toString())).replaceAll("\\{right_ref\\}", this.localVarApiClient.escapeString(rightRef.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tablePath != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("table_path", tablePath));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call otfDiffValidateBeforeCall(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling otfDiff(Async)");
        }
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling otfDiff(Async)");
        }
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling otfDiff(Async)");
        }
        if (tablePath == null) {
            throw new ApiException("Missing the required parameter 'tablePath' when calling otfDiff(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling otfDiff(Async)");
        }
        Call localVarCall = this.otfDiffCall(repository, leftRef, rightRef, tablePath, type, _callback);
        return localVarCall;
    }

    public OtfDiffList otfDiff(String repository, String leftRef, String rightRef, String tablePath, String type) throws ApiException {
        ApiResponse<OtfDiffList> localVarResp = this.otfDiffWithHttpInfo(repository, leftRef, rightRef, tablePath, type);
        return localVarResp.getData();
    }

    public ApiResponse<OtfDiffList> otfDiffWithHttpInfo(String repository, String leftRef, String rightRef, String tablePath, String type) throws ApiException {
        Call localVarCall = this.otfDiffValidateBeforeCall(repository, leftRef, rightRef, tablePath, type, null);
        Type localVarReturnType = new TypeToken<OtfDiffList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call otfDiffAsync(String repository, String leftRef, String rightRef, String tablePath, String type, ApiCallback<OtfDiffList> _callback) throws ApiException {
        Call localVarCall = this.otfDiffValidateBeforeCall(repository, leftRef, rightRef, tablePath, type, _callback);
        Type localVarReturnType = new TypeToken<OtfDiffList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

