/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Repository {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
    @SerializedName(value="creation_date")
    private Long creationDate;
    public static final String SERIALIZED_NAME_DEFAULT_BRANCH = "default_branch";
    @SerializedName(value="default_branch")
    private String defaultBranch;
    public static final String SERIALIZED_NAME_STORAGE_NAMESPACE = "storage_namespace";
    @SerializedName(value="storage_namespace")
    private String storageNamespace;
    public static final String SERIALIZED_NAME_READ_ONLY = "read_only";
    @SerializedName(value="read_only")
    private Boolean readOnly;

    public Repository id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Repository creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unix Epoch in seconds")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Repository defaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public Repository storageNamespace(String storageNamespace) {
        this.storageNamespace = storageNamespace;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Filesystem URI to store the underlying data in (e.g. \"s3://my-bucket/some/path/\")")
    public String getStorageNamespace() {
        return this.storageNamespace;
    }

    public void setStorageNamespace(String storageNamespace) {
        this.storageNamespace = storageNamespace;
    }

    public Repository readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the repository is a read-only repository- not relevant for bare repositories")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository repository = (Repository)o;
        return Objects.equals(this.id, repository.id) && Objects.equals(this.creationDate, repository.creationDate) && Objects.equals(this.defaultBranch, repository.defaultBranch) && Objects.equals(this.storageNamespace, repository.storageNamespace) && Objects.equals(this.readOnly, repository.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.creationDate, this.defaultBranch, this.storageNamespace, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Repository {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    defaultBranch: ").append(this.toIndentedString(this.defaultBranch)).append("\n");
        sb.append("    storageNamespace: ").append(this.toIndentedString(this.storageNamespace)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

