/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExternalPrincipal {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_SETTINGS = "settings";
    @SerializedName(value="settings")
    private List<Map<String, String>> settings = null;

    public ExternalPrincipal id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A unique identifier for the external principal i.e aws:sts::123:assumed-role/role-name")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExternalPrincipal userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="lakeFS user ID to associate with an external principal. ")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ExternalPrincipal settings(List<Map<String, String>> settings) {
        this.settings = settings;
        return this;
    }

    public ExternalPrincipal addSettingsItem(Map<String, String> settingsItem) {
        if (this.settings == null) {
            this.settings = new ArrayList<Map<String, String>>();
        }
        this.settings.add(settingsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Map<String, String>> getSettings() {
        return this.settings;
    }

    public void setSettings(List<Map<String, String>> settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalPrincipal externalPrincipal = (ExternalPrincipal)o;
        return Objects.equals(this.id, externalPrincipal.id) && Objects.equals(this.userId, externalPrincipal.userId) && Objects.equals(this.settings, externalPrincipal.settings);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalPrincipal {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

