/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitRecordCreation {
    public static final String SERIALIZED_NAME_COMMIT_ID = "commit_id";
    @SerializedName(value="commit_id")
    private String commitId;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_COMMITTER = "committer";
    @SerializedName(value="committer")
    private String committer;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_METARANGE_ID = "metarange_id";
    @SerializedName(value="metarange_id")
    private String metarangeId;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
    @SerializedName(value="creation_date")
    private Long creationDate;
    public static final String SERIALIZED_NAME_PARENTS = "parents";
    @SerializedName(value="parents")
    private List<String> parents = new ArrayList<String>();
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_GENERATION = "generation";
    @SerializedName(value="generation")
    private Long generation;
    public static final String SERIALIZED_NAME_FORCE = "force";
    @SerializedName(value="force")
    private Boolean force = false;

    public CommitRecordCreation commitId(String commitId) {
        this.commitId = commitId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="id of the commit record")
    public String getCommitId() {
        return this.commitId;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public CommitRecordCreation version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="version of the commit record")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public CommitRecordCreation committer(String committer) {
        this.committer = committer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="committer of the commit record")
    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public CommitRecordCreation message(String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="message of the commit record")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CommitRecordCreation metarangeId(String metarangeId) {
        this.metarangeId = metarangeId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="metarange_id of the commit record")
    public String getMetarangeId() {
        return this.metarangeId;
    }

    public void setMetarangeId(String metarangeId) {
        this.metarangeId = metarangeId;
    }

    public CommitRecordCreation creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unix Epoch in seconds")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public CommitRecordCreation parents(List<String> parents) {
        this.parents = parents;
        return this;
    }

    public CommitRecordCreation addParentsItem(String parentsItem) {
        this.parents.add(parentsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="parents of the commit record")
    public List<String> getParents() {
        return this.parents;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public CommitRecordCreation metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CommitRecordCreation putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="metadata of the commit record")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CommitRecordCreation generation(Long generation) {
        this.generation = generation;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="generation of the commit record")
    public Long getGeneration() {
        return this.generation;
    }

    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    public CommitRecordCreation force(Boolean force) {
        this.force = force;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitRecordCreation commitRecordCreation = (CommitRecordCreation)o;
        return Objects.equals(this.commitId, commitRecordCreation.commitId) && Objects.equals(this.version, commitRecordCreation.version) && Objects.equals(this.committer, commitRecordCreation.committer) && Objects.equals(this.message, commitRecordCreation.message) && Objects.equals(this.metarangeId, commitRecordCreation.metarangeId) && Objects.equals(this.creationDate, commitRecordCreation.creationDate) && Objects.equals(this.parents, commitRecordCreation.parents) && Objects.equals(this.metadata, commitRecordCreation.metadata) && Objects.equals(this.generation, commitRecordCreation.generation) && Objects.equals(this.force, commitRecordCreation.force);
    }

    public int hashCode() {
        return Objects.hash(this.commitId, this.version, this.committer, this.message, this.metarangeId, this.creationDate, this.parents, this.metadata, this.generation, this.force);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommitRecordCreation {\n");
        sb.append("    commitId: ").append(this.toIndentedString(this.commitId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    committer: ").append(this.toIndentedString(this.committer)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metarangeId: ").append(this.toIndentedString(this.metarangeId)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    parents: ").append(this.toIndentedString(this.parents)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    generation: ").append(this.toIndentedString(this.generation)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

