/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitCreation {
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private Long date;
    public static final String SERIALIZED_NAME_ALLOW_EMPTY = "allow_empty";
    @SerializedName(value="allow_empty")
    private Boolean allowEmpty = false;
    public static final String SERIALIZED_NAME_FORCE = "force";
    @SerializedName(value="force")
    private Boolean force = false;

    public CommitCreation message(String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CommitCreation metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CommitCreation putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CommitCreation date(Long date) {
        this.date = date;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="set date to override creation date in the commit (Unix Epoch in seconds)")
    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public CommitCreation allowEmpty(Boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="sets whether a commit can contain no changes")
    public Boolean getAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(Boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public CommitCreation force(Boolean force) {
        this.force = force;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitCreation commitCreation = (CommitCreation)o;
        return Objects.equals(this.message, commitCreation.message) && Objects.equals(this.metadata, commitCreation.metadata) && Objects.equals(this.date, commitCreation.date) && Objects.equals(this.allowEmpty, commitCreation.allowEmpty) && Objects.equals(this.force, commitCreation.force);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.metadata, this.date, this.allowEmpty, this.force);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommitCreation {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    allowEmpty: ").append(this.toIndentedString(this.allowEmpty)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

