/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.AuthenticationToken;
import io.lakefs.clients.api.model.ExternalLoginInformation;
import io.lakefs.clients.api.model.ExternalPrincipal;
import io.lakefs.clients.api.model.ExternalPrincipalCreation;
import io.lakefs.clients.api.model.ExternalPrincipalList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExternalApi {
    private ApiClient localVarApiClient;

    public ExternalApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExternalApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createUserExternalPrincipalCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        ExternalPrincipalCreation localVarPostBody = externalPrincipalCreation;
        String localVarPath = "/auth/users/{userId}/external/principals".replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling createUserExternalPrincipal(Async)");
        }
        Call localVarCall = this.createUserExternalPrincipalCall(userId, principalId, externalPrincipalCreation, _callback);
        return localVarCall;
    }

    public void createUserExternalPrincipal(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation) throws ApiException {
        this.createUserExternalPrincipalWithHttpInfo(userId, principalId, externalPrincipalCreation);
    }

    public ApiResponse<Void> createUserExternalPrincipalWithHttpInfo(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUserExternalPrincipalAsync(String userId, String principalId, ExternalPrincipalCreation externalPrincipalCreation, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserExternalPrincipalValidateBeforeCall(userId, principalId, externalPrincipalCreation, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserExternalPrincipalCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals".replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserExternalPrincipalValidateBeforeCall(String userId, String principalId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUserExternalPrincipal(Async)");
        }
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling deleteUserExternalPrincipal(Async)");
        }
        Call localVarCall = this.deleteUserExternalPrincipalCall(userId, principalId, _callback);
        return localVarCall;
    }

    public void deleteUserExternalPrincipal(String userId, String principalId) throws ApiException {
        this.deleteUserExternalPrincipalWithHttpInfo(userId, principalId);
    }

    public ApiResponse<Void> deleteUserExternalPrincipalWithHttpInfo(String userId, String principalId) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserExternalPrincipalAsync(String userId, String principalId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserExternalPrincipalValidateBeforeCall(userId, principalId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call externalPrincipalLoginCall(ExternalLoginInformation externalLoginInformation, ApiCallback _callback) throws ApiException {
        ExternalLoginInformation localVarPostBody = externalLoginInformation;
        String localVarPath = "/auth/external/principal/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call externalPrincipalLoginValidateBeforeCall(ExternalLoginInformation externalLoginInformation, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.externalPrincipalLoginCall(externalLoginInformation, _callback);
        return localVarCall;
    }

    public AuthenticationToken externalPrincipalLogin(ExternalLoginInformation externalLoginInformation) throws ApiException {
        ApiResponse<AuthenticationToken> localVarResp = this.externalPrincipalLoginWithHttpInfo(externalLoginInformation);
        return localVarResp.getData();
    }

    public ApiResponse<AuthenticationToken> externalPrincipalLoginWithHttpInfo(ExternalLoginInformation externalLoginInformation) throws ApiException {
        Call localVarCall = this.externalPrincipalLoginValidateBeforeCall(externalLoginInformation, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call externalPrincipalLoginAsync(ExternalLoginInformation externalLoginInformation, ApiCallback<AuthenticationToken> _callback) throws ApiException {
        Call localVarCall = this.externalPrincipalLoginValidateBeforeCall(externalLoginInformation, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExternalPrincipalCall(String principalId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/auth/external/principals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (principalId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("principalId", principalId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExternalPrincipalValidateBeforeCall(String principalId, ApiCallback _callback) throws ApiException {
        if (principalId == null) {
            throw new ApiException("Missing the required parameter 'principalId' when calling getExternalPrincipal(Async)");
        }
        Call localVarCall = this.getExternalPrincipalCall(principalId, _callback);
        return localVarCall;
    }

    public ExternalPrincipal getExternalPrincipal(String principalId) throws ApiException {
        ApiResponse<ExternalPrincipal> localVarResp = this.getExternalPrincipalWithHttpInfo(principalId);
        return localVarResp.getData();
    }

    public ApiResponse<ExternalPrincipal> getExternalPrincipalWithHttpInfo(String principalId) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExternalPrincipalAsync(String principalId, ApiCallback<ExternalPrincipal> _callback) throws ApiException {
        Call localVarCall = this.getExternalPrincipalValidateBeforeCall(principalId, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipal>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserExternalPrincipalsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/external/principals/ls".replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserExternalPrincipalsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserExternalPrincipals(Async)");
        }
        Call localVarCall = this.listUserExternalPrincipalsCall(userId, prefix, after, amount, _callback);
        return localVarCall;
    }

    public ExternalPrincipalList listUserExternalPrincipals(String userId, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<ExternalPrincipalList> localVarResp = this.listUserExternalPrincipalsWithHttpInfo(userId, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<ExternalPrincipalList> listUserExternalPrincipalsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUserExternalPrincipalsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<ExternalPrincipalList> _callback) throws ApiException {
        Call localVarCall = this.listUserExternalPrincipalsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<ExternalPrincipalList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

