/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.api;

import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.ProgressRequestBody;
import io.lakefs.clients.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.lakefs.clients.api.model.CommitList;
import io.lakefs.clients.api.model.DiffList;
import io.lakefs.clients.api.model.Error;
import io.lakefs.clients.api.model.FindMergeBaseResult;
import io.lakefs.clients.api.model.Merge;
import io.lakefs.clients.api.model.MergeResult;
import org.threeten.bp.OffsetDateTime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RefsApi {
    private ApiClient localVarApiClient;

    public RefsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RefsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for diffRefs
     * @param repository  (required)
     * @param leftRef a reference (could be either a branch or a commit ID) (required)
     * @param rightRef a reference (could be either a branch or a commit ID) to compare against (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param prefix return items prefixed with this value (optional)
     * @param delimiter delimiter used to group common prefixes by (optional)
     * @param type  (optional, default to three_dot)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call diffRefsCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{leftRef}/diff/{rightRef}"
            .replaceAll("\\{" + "repository" + "\\}", localVarApiClient.escapeString(repository.toString()))
            .replaceAll("\\{" + "leftRef" + "\\}", localVarApiClient.escapeString(leftRef.toString()))
            .replaceAll("\\{" + "rightRef" + "\\}", localVarApiClient.escapeString(rightRef.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        if (prefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("prefix", prefix));
        }

        if (delimiter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delimiter", delimiter));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call diffRefsValidateBeforeCall(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling diffRefs(Async)");
        }
        
        // verify the required parameter 'leftRef' is set
        if (leftRef == null) {
            throw new ApiException("Missing the required parameter 'leftRef' when calling diffRefs(Async)");
        }
        
        // verify the required parameter 'rightRef' is set
        if (rightRef == null) {
            throw new ApiException("Missing the required parameter 'rightRef' when calling diffRefs(Async)");
        }
        

        okhttp3.Call localVarCall = diffRefsCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        return localVarCall;

    }

    /**
     * diff references
     * 
     * @param repository  (required)
     * @param leftRef a reference (could be either a branch or a commit ID) (required)
     * @param rightRef a reference (could be either a branch or a commit ID) to compare against (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param prefix return items prefixed with this value (optional)
     * @param delimiter delimiter used to group common prefixes by (optional)
     * @param type  (optional, default to three_dot)
     * @return DiffList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public DiffList diffRefs(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type) throws ApiException {
        ApiResponse<DiffList> localVarResp = diffRefsWithHttpInfo(repository, leftRef, rightRef, after, amount, prefix, delimiter, type);
        return localVarResp.getData();
    }

    /**
     * diff references
     * 
     * @param repository  (required)
     * @param leftRef a reference (could be either a branch or a commit ID) (required)
     * @param rightRef a reference (could be either a branch or a commit ID) to compare against (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param prefix return items prefixed with this value (optional)
     * @param delimiter delimiter used to group common prefixes by (optional)
     * @param type  (optional, default to three_dot)
     * @return ApiResponse&lt;DiffList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DiffList> diffRefsWithHttpInfo(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type) throws ApiException {
        okhttp3.Call localVarCall = diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, null);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * diff references (asynchronously)
     * 
     * @param repository  (required)
     * @param leftRef a reference (could be either a branch or a commit ID) (required)
     * @param rightRef a reference (could be either a branch or a commit ID) to compare against (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param prefix return items prefixed with this value (optional)
     * @param delimiter delimiter used to group common prefixes by (optional)
     * @param type  (optional, default to three_dot)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> diff between refs </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call diffRefsAsync(String repository, String leftRef, String rightRef, String after, Integer amount, String prefix, String delimiter, String type, final ApiCallback<DiffList> _callback) throws ApiException {

        okhttp3.Call localVarCall = diffRefsValidateBeforeCall(repository, leftRef, rightRef, after, amount, prefix, delimiter, type, _callback);
        Type localVarReturnType = new TypeToken<DiffList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for findMergeBase
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findMergeBaseCall(String repository, String sourceRef, String destinationBranch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}"
            .replaceAll("\\{" + "repository" + "\\}", localVarApiClient.escapeString(repository.toString()))
            .replaceAll("\\{" + "sourceRef" + "\\}", localVarApiClient.escapeString(sourceRef.toString()))
            .replaceAll("\\{" + "destinationBranch" + "\\}", localVarApiClient.escapeString(destinationBranch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call findMergeBaseValidateBeforeCall(String repository, String sourceRef, String destinationBranch, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling findMergeBase(Async)");
        }
        
        // verify the required parameter 'sourceRef' is set
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling findMergeBase(Async)");
        }
        
        // verify the required parameter 'destinationBranch' is set
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling findMergeBase(Async)");
        }
        

        okhttp3.Call localVarCall = findMergeBaseCall(repository, sourceRef, destinationBranch, _callback);
        return localVarCall;

    }

    /**
     * find the merge base for 2 references
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @return FindMergeBaseResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public FindMergeBaseResult findMergeBase(String repository, String sourceRef, String destinationBranch) throws ApiException {
        ApiResponse<FindMergeBaseResult> localVarResp = findMergeBaseWithHttpInfo(repository, sourceRef, destinationBranch);
        return localVarResp.getData();
    }

    /**
     * find the merge base for 2 references
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @return ApiResponse&lt;FindMergeBaseResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FindMergeBaseResult> findMergeBaseWithHttpInfo(String repository, String sourceRef, String destinationBranch) throws ApiException {
        okhttp3.Call localVarCall = findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, null);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * find the merge base for 2 references (asynchronously)
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Found the merge base </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call findMergeBaseAsync(String repository, String sourceRef, String destinationBranch, final ApiCallback<FindMergeBaseResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = findMergeBaseValidateBeforeCall(repository, sourceRef, destinationBranch, _callback);
        Type localVarReturnType = new TypeToken<FindMergeBaseResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for logCommits
     * @param repository  (required)
     * @param ref  (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param objects list of paths, each element is a path of a specific object (optional)
     * @param prefixes list of paths, each element is a path of a prefix (optional)
     * @param limit limit the number of items in return to &#39;amount&#39;. Without further indication on actual number of items. (optional)
     * @param firstParent if set to true, follow only the first parent upon reaching a merge commit (optional)
     * @param since Show commits more recent than a specific date-time. In case used with stop_at parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @param stopAt A reference to stop at. In case used with since parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call logCommitsCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, OffsetDateTime since, String stopAt, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{ref}/commits"
            .replaceAll("\\{" + "repository" + "\\}", localVarApiClient.escapeString(repository.toString()))
            .replaceAll("\\{" + "ref" + "\\}", localVarApiClient.escapeString(ref.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (after != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("after", after));
        }

        if (amount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("amount", amount));
        }

        if (objects != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "objects", objects));
        }

        if (prefixes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "prefixes", prefixes));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (firstParent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("first_parent", firstParent));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (stopAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stop_at", stopAt));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call logCommitsValidateBeforeCall(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, OffsetDateTime since, String stopAt, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling logCommits(Async)");
        }
        
        // verify the required parameter 'ref' is set
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling logCommits(Async)");
        }
        

        okhttp3.Call localVarCall = logCommitsCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, since, stopAt, _callback);
        return localVarCall;

    }

    /**
     * get commit log from ref. If both objects and prefixes are empty, return all commits.
     * 
     * @param repository  (required)
     * @param ref  (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param objects list of paths, each element is a path of a specific object (optional)
     * @param prefixes list of paths, each element is a path of a prefix (optional)
     * @param limit limit the number of items in return to &#39;amount&#39;. Without further indication on actual number of items. (optional)
     * @param firstParent if set to true, follow only the first parent upon reaching a merge commit (optional)
     * @param since Show commits more recent than a specific date-time. In case used with stop_at parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @param stopAt A reference to stop at. In case used with since parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @return CommitList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public CommitList logCommits(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, OffsetDateTime since, String stopAt) throws ApiException {
        ApiResponse<CommitList> localVarResp = logCommitsWithHttpInfo(repository, ref, after, amount, objects, prefixes, limit, firstParent, since, stopAt);
        return localVarResp.getData();
    }

    /**
     * get commit log from ref. If both objects and prefixes are empty, return all commits.
     * 
     * @param repository  (required)
     * @param ref  (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param objects list of paths, each element is a path of a specific object (optional)
     * @param prefixes list of paths, each element is a path of a prefix (optional)
     * @param limit limit the number of items in return to &#39;amount&#39;. Without further indication on actual number of items. (optional)
     * @param firstParent if set to true, follow only the first parent upon reaching a merge commit (optional)
     * @param since Show commits more recent than a specific date-time. In case used with stop_at parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @param stopAt A reference to stop at. In case used with since parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @return ApiResponse&lt;CommitList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CommitList> logCommitsWithHttpInfo(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, OffsetDateTime since, String stopAt) throws ApiException {
        okhttp3.Call localVarCall = logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, since, stopAt, null);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * get commit log from ref. If both objects and prefixes are empty, return all commits. (asynchronously)
     * 
     * @param repository  (required)
     * @param ref  (required)
     * @param after return items after this value (optional)
     * @param amount how many items to return (optional, default to 100)
     * @param objects list of paths, each element is a path of a specific object (optional)
     * @param prefixes list of paths, each element is a path of a prefix (optional)
     * @param limit limit the number of items in return to &#39;amount&#39;. Without further indication on actual number of items. (optional)
     * @param firstParent if set to true, follow only the first parent upon reaching a merge commit (optional)
     * @param since Show commits more recent than a specific date-time. In case used with stop_at parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @param stopAt A reference to stop at. In case used with since parameter, will stop at the first commit that meets any of the conditions. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> commit log </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call logCommitsAsync(String repository, String ref, String after, Integer amount, List<String> objects, List<String> prefixes, Boolean limit, Boolean firstParent, OffsetDateTime since, String stopAt, final ApiCallback<CommitList> _callback) throws ApiException {

        okhttp3.Call localVarCall = logCommitsValidateBeforeCall(repository, ref, after, amount, objects, prefixes, limit, firstParent, since, stopAt, _callback);
        Type localVarReturnType = new TypeToken<CommitList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for mergeIntoBranch
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @param merge  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call mergeIntoBranchCall(String repository, String sourceRef, String destinationBranch, Merge merge, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = merge;

        // create path and map variables
        String localVarPath = "/repositories/{repository}/refs/{sourceRef}/merge/{destinationBranch}"
            .replaceAll("\\{" + "repository" + "\\}", localVarApiClient.escapeString(repository.toString()))
            .replaceAll("\\{" + "sourceRef" + "\\}", localVarApiClient.escapeString(sourceRef.toString()))
            .replaceAll("\\{" + "destinationBranch" + "\\}", localVarApiClient.escapeString(destinationBranch.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call mergeIntoBranchValidateBeforeCall(String repository, String sourceRef, String destinationBranch, Merge merge, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'repository' is set
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling mergeIntoBranch(Async)");
        }
        
        // verify the required parameter 'sourceRef' is set
        if (sourceRef == null) {
            throw new ApiException("Missing the required parameter 'sourceRef' when calling mergeIntoBranch(Async)");
        }
        
        // verify the required parameter 'destinationBranch' is set
        if (destinationBranch == null) {
            throw new ApiException("Missing the required parameter 'destinationBranch' when calling mergeIntoBranch(Async)");
        }
        

        okhttp3.Call localVarCall = mergeIntoBranchCall(repository, sourceRef, destinationBranch, merge, _callback);
        return localVarCall;

    }

    /**
     * merge references
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @param merge  (optional)
     * @return MergeResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public MergeResult mergeIntoBranch(String repository, String sourceRef, String destinationBranch, Merge merge) throws ApiException {
        ApiResponse<MergeResult> localVarResp = mergeIntoBranchWithHttpInfo(repository, sourceRef, destinationBranch, merge);
        return localVarResp.getData();
    }

    /**
     * merge references
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @param merge  (optional)
     * @return ApiResponse&lt;MergeResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MergeResult> mergeIntoBranchWithHttpInfo(String repository, String sourceRef, String destinationBranch, Merge merge) throws ApiException {
        okhttp3.Call localVarCall = mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, null);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * merge references (asynchronously)
     * 
     * @param repository  (required)
     * @param sourceRef source ref (required)
     * @param destinationBranch destination branch name (required)
     * @param merge  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> merge completed </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Validation Error </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Resource Not Found </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict Deprecated: content schema will return Error format and not an empty MergeResult  </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> precondition failed (e.g. a pre-merge hook returned a failure) </td><td>  -  </td></tr>
        <tr><td> 420 </td><td> too many requests </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> Internal Server Error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call mergeIntoBranchAsync(String repository, String sourceRef, String destinationBranch, Merge merge, final ApiCallback<MergeResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = mergeIntoBranchValidateBeforeCall(repository, sourceRef, destinationBranch, merge, _callback);
        Type localVarReturnType = new TypeToken<MergeResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
