/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RevertCreation {
    public static final String SERIALIZED_NAME_REF = "ref";
    @SerializedName(value="ref")
    private String ref;
    public static final String SERIALIZED_NAME_PARENT_NUMBER = "parent_number";
    @SerializedName(value="parent_number")
    private Integer parentNumber;
    public static final String SERIALIZED_NAME_FORCE = "force";
    @SerializedName(value="force")
    private Boolean force = false;
    public static final String SERIALIZED_NAME_ALLOW_EMPTY = "allow_empty";
    @SerializedName(value="allow_empty")
    private Boolean allowEmpty = false;

    public RevertCreation ref(String ref) {
        this.ref = ref;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the commit to revert, given by a ref")
    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public RevertCreation parentNumber(Integer parentNumber) {
        this.parentNumber = parentNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="when reverting a merge commit, the parent number (starting from 1) relative to which to perform the revert.")
    public Integer getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(Integer parentNumber) {
        this.parentNumber = parentNumber;
    }

    public RevertCreation force(Boolean force) {
        this.force = force;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public RevertCreation allowEmpty(Boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allow empty commit (revert without changes)")
    public Boolean getAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(Boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevertCreation revertCreation = (RevertCreation)o;
        return Objects.equals(this.ref, revertCreation.ref) && Objects.equals(this.parentNumber, revertCreation.parentNumber) && Objects.equals(this.force, revertCreation.force) && Objects.equals(this.allowEmpty, revertCreation.allowEmpty);
    }

    public int hashCode() {
        return Objects.hash(this.ref, this.parentNumber, this.force, this.allowEmpty);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RevertCreation {\n");
        sb.append("    ref: ").append(this.toIndentedString(this.ref)).append("\n");
        sb.append("    parentNumber: ").append(this.toIndentedString(this.parentNumber)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("    allowEmpty: ").append(this.toIndentedString(this.allowEmpty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

