/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.lakefs.clients.api.model.Commit;
import io.lakefs.clients.api.model.Error;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

public class ImportStatus {
    public static final String SERIALIZED_NAME_COMPLETED = "completed";
    @SerializedName(value="completed")
    private Boolean completed;
    public static final String SERIALIZED_NAME_UPDATE_TIME = "update_time";
    @SerializedName(value="update_time")
    private OffsetDateTime updateTime;
    public static final String SERIALIZED_NAME_INGESTED_OBJECTS = "ingested_objects";
    @SerializedName(value="ingested_objects")
    private Long ingestedObjects;
    public static final String SERIALIZED_NAME_METARANGE_ID = "metarange_id";
    @SerializedName(value="metarange_id")
    private String metarangeId;
    public static final String SERIALIZED_NAME_COMMIT = "commit";
    @SerializedName(value="commit")
    private Commit commit;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private Error error;

    public ImportStatus completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public ImportStatus updateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public ImportStatus ingestedObjects(Long ingestedObjects) {
        this.ingestedObjects = ingestedObjects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of objects processed so far")
    public Long getIngestedObjects() {
        return this.ingestedObjects;
    }

    public void setIngestedObjects(Long ingestedObjects) {
        this.ingestedObjects = ingestedObjects;
    }

    public ImportStatus metarangeId(String metarangeId) {
        this.metarangeId = metarangeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getMetarangeId() {
        return this.metarangeId;
    }

    public void setMetarangeId(String metarangeId) {
        this.metarangeId = metarangeId;
    }

    public ImportStatus commit(Commit commit) {
        this.commit = commit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Commit getCommit() {
        return this.commit;
    }

    public void setCommit(Commit commit) {
        this.commit = commit;
    }

    public ImportStatus error(Error error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportStatus importStatus = (ImportStatus)o;
        return Objects.equals(this.completed, importStatus.completed) && Objects.equals(this.updateTime, importStatus.updateTime) && Objects.equals(this.ingestedObjects, importStatus.ingestedObjects) && Objects.equals(this.metarangeId, importStatus.metarangeId) && Objects.equals(this.commit, importStatus.commit) && Objects.equals(this.error, importStatus.error);
    }

    public int hashCode() {
        return Objects.hash(this.completed, this.updateTime, this.ingestedObjects, this.metarangeId, this.commit, this.error);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportStatus {\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    updateTime: ").append(this.toIndentedString(this.updateTime)).append("\n");
        sb.append("    ingestedObjects: ").append(this.toIndentedString(this.ingestedObjects)).append("\n");
        sb.append("    metarangeId: ").append(this.toIndentedString(this.metarangeId)).append("\n");
        sb.append("    commit: ").append(this.toIndentedString(this.commit)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

