/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CherryPickCreation {
    public static final String SERIALIZED_NAME_REF = "ref";
    @SerializedName(value="ref")
    private String ref;
    public static final String SERIALIZED_NAME_PARENT_NUMBER = "parent_number";
    @SerializedName(value="parent_number")
    private Integer parentNumber;
    public static final String SERIALIZED_NAME_FORCE = "force";
    @SerializedName(value="force")
    private Boolean force = false;

    public CherryPickCreation ref(String ref) {
        this.ref = ref;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the commit to cherry-pick, given by a ref")
    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public CherryPickCreation parentNumber(Integer parentNumber) {
        this.parentNumber = parentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When cherry-picking a merge commit, the parent number (starting from 1) with which to perform the diff. The default branch is parent 1. ")
    public Integer getParentNumber() {
        return this.parentNumber;
    }

    public void setParentNumber(Integer parentNumber) {
        this.parentNumber = parentNumber;
    }

    public CherryPickCreation force(Boolean force) {
        this.force = force;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CherryPickCreation cherryPickCreation = (CherryPickCreation)o;
        return Objects.equals(this.ref, cherryPickCreation.ref) && Objects.equals(this.parentNumber, cherryPickCreation.parentNumber) && Objects.equals(this.force, cherryPickCreation.force);
    }

    public int hashCode() {
        return Objects.hash(this.ref, this.parentNumber, this.force);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CherryPickCreation {\n");
        sb.append("    ref: ").append(this.toIndentedString(this.ref)).append("\n");
        sb.append("    parentNumber: ").append(this.toIndentedString(this.parentNumber)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

