/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * LoginConfig
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class LoginConfig {
  /**
   * RBAC will remain enabled on GUI if \&quot;external\&quot;.  That only works with an external auth service. 
   */
  @JsonAdapter(RBACEnum.Adapter.class)
  public enum RBACEnum {
    SIMPLIFIED("simplified"),
    
    EXTERNAL("external");

    private String value;

    RBACEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RBACEnum fromValue(String value) {
      for (RBACEnum b : RBACEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RBACEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RBACEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RBACEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RBACEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_R_B_A_C = "RBAC";
  @SerializedName(SERIALIZED_NAME_R_B_A_C)
  private RBACEnum RBAC;

  public static final String SERIALIZED_NAME_LOGIN_URL = "login_url";
  @SerializedName(SERIALIZED_NAME_LOGIN_URL)
  private String loginUrl;

  public static final String SERIALIZED_NAME_LOGIN_FAILED_MESSAGE = "login_failed_message";
  @SerializedName(SERIALIZED_NAME_LOGIN_FAILED_MESSAGE)
  private String loginFailedMessage;

  public static final String SERIALIZED_NAME_FALLBACK_LOGIN_URL = "fallback_login_url";
  @SerializedName(SERIALIZED_NAME_FALLBACK_LOGIN_URL)
  private String fallbackLoginUrl;

  public static final String SERIALIZED_NAME_FALLBACK_LOGIN_LABEL = "fallback_login_label";
  @SerializedName(SERIALIZED_NAME_FALLBACK_LOGIN_LABEL)
  private String fallbackLoginLabel;

  public static final String SERIALIZED_NAME_LOGIN_COOKIE_NAMES = "login_cookie_names";
  @SerializedName(SERIALIZED_NAME_LOGIN_COOKIE_NAMES)
  private List<String> loginCookieNames = new ArrayList<String>();

  public static final String SERIALIZED_NAME_LOGOUT_URL = "logout_url";
  @SerializedName(SERIALIZED_NAME_LOGOUT_URL)
  private String logoutUrl;


  public LoginConfig RBAC(RBACEnum RBAC) {
    
    this.RBAC = RBAC;
    return this;
  }

   /**
   * RBAC will remain enabled on GUI if \&quot;external\&quot;.  That only works with an external auth service. 
   * @return RBAC
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RBAC will remain enabled on GUI if \"external\".  That only works with an external auth service. ")

  public RBACEnum getRBAC() {
    return RBAC;
  }


  public void setRBAC(RBACEnum RBAC) {
    this.RBAC = RBAC;
  }


  public LoginConfig loginUrl(String loginUrl) {
    
    this.loginUrl = loginUrl;
    return this;
  }

   /**
   * primary URL to use for login.
   * @return loginUrl
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "primary URL to use for login.")

  public String getLoginUrl() {
    return loginUrl;
  }


  public void setLoginUrl(String loginUrl) {
    this.loginUrl = loginUrl;
  }


  public LoginConfig loginFailedMessage(String loginFailedMessage) {
    
    this.loginFailedMessage = loginFailedMessage;
    return this;
  }

   /**
   * message to display to users who fail to login; a full sentence that is rendered in HTML and may contain a link to a secondary login method 
   * @return loginFailedMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "message to display to users who fail to login; a full sentence that is rendered in HTML and may contain a link to a secondary login method ")

  public String getLoginFailedMessage() {
    return loginFailedMessage;
  }


  public void setLoginFailedMessage(String loginFailedMessage) {
    this.loginFailedMessage = loginFailedMessage;
  }


  public LoginConfig fallbackLoginUrl(String fallbackLoginUrl) {
    
    this.fallbackLoginUrl = fallbackLoginUrl;
    return this;
  }

   /**
   * secondary URL to offer users to use for login.
   * @return fallbackLoginUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "secondary URL to offer users to use for login.")

  public String getFallbackLoginUrl() {
    return fallbackLoginUrl;
  }


  public void setFallbackLoginUrl(String fallbackLoginUrl) {
    this.fallbackLoginUrl = fallbackLoginUrl;
  }


  public LoginConfig fallbackLoginLabel(String fallbackLoginLabel) {
    
    this.fallbackLoginLabel = fallbackLoginLabel;
    return this;
  }

   /**
   * label to place on fallback_login_url.
   * @return fallbackLoginLabel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "label to place on fallback_login_url.")

  public String getFallbackLoginLabel() {
    return fallbackLoginLabel;
  }


  public void setFallbackLoginLabel(String fallbackLoginLabel) {
    this.fallbackLoginLabel = fallbackLoginLabel;
  }


  public LoginConfig loginCookieNames(List<String> loginCookieNames) {
    
    this.loginCookieNames = loginCookieNames;
    return this;
  }

  public LoginConfig addLoginCookieNamesItem(String loginCookieNamesItem) {
    this.loginCookieNames.add(loginCookieNamesItem);
    return this;
  }

   /**
   * cookie names used to store JWT
   * @return loginCookieNames
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "cookie names used to store JWT")

  public List<String> getLoginCookieNames() {
    return loginCookieNames;
  }


  public void setLoginCookieNames(List<String> loginCookieNames) {
    this.loginCookieNames = loginCookieNames;
  }


  public LoginConfig logoutUrl(String logoutUrl) {
    
    this.logoutUrl = logoutUrl;
    return this;
  }

   /**
   * URL to use for logging out.
   * @return logoutUrl
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "URL to use for logging out.")

  public String getLogoutUrl() {
    return logoutUrl;
  }


  public void setLogoutUrl(String logoutUrl) {
    this.logoutUrl = logoutUrl;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoginConfig loginConfig = (LoginConfig) o;
    return Objects.equals(this.RBAC, loginConfig.RBAC) &&
        Objects.equals(this.loginUrl, loginConfig.loginUrl) &&
        Objects.equals(this.loginFailedMessage, loginConfig.loginFailedMessage) &&
        Objects.equals(this.fallbackLoginUrl, loginConfig.fallbackLoginUrl) &&
        Objects.equals(this.fallbackLoginLabel, loginConfig.fallbackLoginLabel) &&
        Objects.equals(this.loginCookieNames, loginConfig.loginCookieNames) &&
        Objects.equals(this.logoutUrl, loginConfig.logoutUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(RBAC, loginUrl, loginFailedMessage, fallbackLoginUrl, fallbackLoginLabel, loginCookieNames, logoutUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoginConfig {\n");
    sb.append("    RBAC: ").append(toIndentedString(RBAC)).append("\n");
    sb.append("    loginUrl: ").append(toIndentedString(loginUrl)).append("\n");
    sb.append("    loginFailedMessage: ").append(toIndentedString(loginFailedMessage)).append("\n");
    sb.append("    fallbackLoginUrl: ").append(toIndentedString(fallbackLoginUrl)).append("\n");
    sb.append("    fallbackLoginLabel: ").append(toIndentedString(fallbackLoginLabel)).append("\n");
    sb.append("    loginCookieNames: ").append(toIndentedString(loginCookieNames)).append("\n");
    sb.append("    logoutUrl: ").append(toIndentedString(logoutUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

