/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CommitRecordCreation
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CommitRecordCreation {
  public static final String SERIALIZED_NAME_COMMIT_ID = "commit_id";
  @SerializedName(SERIALIZED_NAME_COMMIT_ID)
  private String commitId;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private Integer version;

  public static final String SERIALIZED_NAME_COMMITTER = "committer";
  @SerializedName(SERIALIZED_NAME_COMMITTER)
  private String committer;

  public static final String SERIALIZED_NAME_MESSAGE = "message";
  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private String message;

  public static final String SERIALIZED_NAME_METARANGE_ID = "metarange_id";
  @SerializedName(SERIALIZED_NAME_METARANGE_ID)
  private String metarangeId;

  public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE)
  private Long creationDate;

  public static final String SERIALIZED_NAME_PARENTS = "parents";
  @SerializedName(SERIALIZED_NAME_PARENTS)
  private List<String> parents = new ArrayList<String>();

  public static final String SERIALIZED_NAME_METADATA = "metadata";
  @SerializedName(SERIALIZED_NAME_METADATA)
  private Map<String, String> metadata = null;

  public static final String SERIALIZED_NAME_GENERATION = "generation";
  @SerializedName(SERIALIZED_NAME_GENERATION)
  private Long generation;

  public static final String SERIALIZED_NAME_FORCE = "force";
  @SerializedName(SERIALIZED_NAME_FORCE)
  private Boolean force = false;


  public CommitRecordCreation commitId(String commitId) {
    
    this.commitId = commitId;
    return this;
  }

   /**
   * id of the commit record
   * @return commitId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "id of the commit record")

  public String getCommitId() {
    return commitId;
  }


  public void setCommitId(String commitId) {
    this.commitId = commitId;
  }


  public CommitRecordCreation version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * version of the commit record
   * minimum: 0
   * maximum: 1
   * @return version
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "version of the commit record")

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public CommitRecordCreation committer(String committer) {
    
    this.committer = committer;
    return this;
  }

   /**
   * committer of the commit record
   * @return committer
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "committer of the commit record")

  public String getCommitter() {
    return committer;
  }


  public void setCommitter(String committer) {
    this.committer = committer;
  }


  public CommitRecordCreation message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * message of the commit record
   * @return message
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "message of the commit record")

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  public CommitRecordCreation metarangeId(String metarangeId) {
    
    this.metarangeId = metarangeId;
    return this;
  }

   /**
   * metarange_id of the commit record
   * @return metarangeId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "metarange_id of the commit record")

  public String getMetarangeId() {
    return metarangeId;
  }


  public void setMetarangeId(String metarangeId) {
    this.metarangeId = metarangeId;
  }


  public CommitRecordCreation creationDate(Long creationDate) {
    
    this.creationDate = creationDate;
    return this;
  }

   /**
   * Unix Epoch in seconds
   * @return creationDate
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Unix Epoch in seconds")

  public Long getCreationDate() {
    return creationDate;
  }


  public void setCreationDate(Long creationDate) {
    this.creationDate = creationDate;
  }


  public CommitRecordCreation parents(List<String> parents) {
    
    this.parents = parents;
    return this;
  }

  public CommitRecordCreation addParentsItem(String parentsItem) {
    this.parents.add(parentsItem);
    return this;
  }

   /**
   * parents of the commit record
   * @return parents
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "parents of the commit record")

  public List<String> getParents() {
    return parents;
  }


  public void setParents(List<String> parents) {
    this.parents = parents;
  }


  public CommitRecordCreation metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public CommitRecordCreation putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<String, String>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * metadata of the commit record
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "metadata of the commit record")

  public Map<String, String> getMetadata() {
    return metadata;
  }


  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public CommitRecordCreation generation(Long generation) {
    
    this.generation = generation;
    return this;
  }

   /**
   * generation of the commit record
   * @return generation
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "generation of the commit record")

  public Long getGeneration() {
    return generation;
  }


  public void setGeneration(Long generation) {
    this.generation = generation;
  }


  public CommitRecordCreation force(Boolean force) {
    
    this.force = force;
    return this;
  }

   /**
   * Get force
   * @return force
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getForce() {
    return force;
  }


  public void setForce(Boolean force) {
    this.force = force;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommitRecordCreation commitRecordCreation = (CommitRecordCreation) o;
    return Objects.equals(this.commitId, commitRecordCreation.commitId) &&
        Objects.equals(this.version, commitRecordCreation.version) &&
        Objects.equals(this.committer, commitRecordCreation.committer) &&
        Objects.equals(this.message, commitRecordCreation.message) &&
        Objects.equals(this.metarangeId, commitRecordCreation.metarangeId) &&
        Objects.equals(this.creationDate, commitRecordCreation.creationDate) &&
        Objects.equals(this.parents, commitRecordCreation.parents) &&
        Objects.equals(this.metadata, commitRecordCreation.metadata) &&
        Objects.equals(this.generation, commitRecordCreation.generation) &&
        Objects.equals(this.force, commitRecordCreation.force);
  }

  @Override
  public int hashCode() {
    return Objects.hash(commitId, version, committer, message, metarangeId, creationDate, parents, metadata, generation, force);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommitRecordCreation {\n");
    sb.append("    commitId: ").append(toIndentedString(commitId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    committer: ").append(toIndentedString(committer)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    metarangeId: ").append(toIndentedString(metarangeId)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    parents: ").append(toIndentedString(parents)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    generation: ").append(toIndentedString(generation)).append("\n");
    sb.append("    force: ").append(toIndentedString(force)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

