/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.StorageURI;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class MetadataApi {
    private ApiClient localVarApiClient;

    public MetadataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetadataApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getMetaRangeCall(String repository, String metaRange, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/metadata/meta_range/{meta_range}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{meta_range\\}", this.localVarApiClient.escapeString(metaRange.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetaRangeValidateBeforeCall(String repository, String metaRange, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getMetaRange(Async)");
        }
        if (metaRange == null) {
            throw new ApiException("Missing the required parameter 'metaRange' when calling getMetaRange(Async)");
        }
        Call localVarCall = this.getMetaRangeCall(repository, metaRange, _callback);
        return localVarCall;
    }

    public StorageURI getMetaRange(String repository, String metaRange) throws ApiException {
        ApiResponse<StorageURI> localVarResp = this.getMetaRangeWithHttpInfo(repository, metaRange);
        return localVarResp.getData();
    }

    public ApiResponse<StorageURI> getMetaRangeWithHttpInfo(String repository, String metaRange) throws ApiException {
        Call localVarCall = this.getMetaRangeValidateBeforeCall(repository, metaRange, null);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetaRangeAsync(String repository, String metaRange, ApiCallback<StorageURI> _callback) throws ApiException {
        Call localVarCall = this.getMetaRangeValidateBeforeCall(repository, metaRange, _callback);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRangeCall(String repository, String range, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/metadata/range/{range}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{range\\}", this.localVarApiClient.escapeString(range.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth", "saml_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRangeValidateBeforeCall(String repository, String range, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRange(Async)");
        }
        if (range == null) {
            throw new ApiException("Missing the required parameter 'range' when calling getRange(Async)");
        }
        Call localVarCall = this.getRangeCall(repository, range, _callback);
        return localVarCall;
    }

    public StorageURI getRange(String repository, String range) throws ApiException {
        ApiResponse<StorageURI> localVarResp = this.getRangeWithHttpInfo(repository, range);
        return localVarResp.getData();
    }

    public ApiResponse<StorageURI> getRangeWithHttpInfo(String repository, String range) throws ApiException {
        Call localVarCall = this.getRangeValidateBeforeCall(repository, range, null);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRangeAsync(String repository, String range, ApiCallback<StorageURI> _callback) throws ApiException {
        Call localVarCall = this.getRangeValidateBeforeCall(repository, range, _callback);
        Type localVarReturnType = new TypeToken<StorageURI>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

