/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ACL {
    public static final String SERIALIZED_NAME_PERMISSION = "permission";
    @SerializedName(value="permission")
    private String permission;
    public static final String SERIALIZED_NAME_ALL_REPOSITORIES = "all_repositories";
    @SerializedName(value="all_repositories")
    private Boolean allRepositories;
    public static final String SERIALIZED_NAME_REPOSITORIES = "repositories";
    @SerializedName(value="repositories")
    private List<String> repositories = null;

    public ACL permission(String permission) {
        this.permission = permission;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Permission level to give this ACL.  \"Read\", \"Write\", \"Super\" and \"Admin\" are all supported. ")
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public ACL allRepositories(Boolean allRepositories) {
        this.allRepositories = allRepositories;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this ACL applies to all repositories, including those added in future.  Permission \"Admin\" allows changing ACLs, so this is necessarily true for that permission. ")
    public Boolean getAllRepositories() {
        return this.allRepositories;
    }

    public void setAllRepositories(Boolean allRepositories) {
        this.allRepositories = allRepositories;
    }

    public ACL repositories(List<String> repositories) {
        this.repositories = repositories;
        return this;
    }

    public ACL addRepositoriesItem(String repositoriesItem) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.add(repositoriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply this ACL only to these repositories.")
    public List<String> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<String> repositories) {
        this.repositories = repositories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACL ACL2 = (ACL)o;
        return Objects.equals(this.permission, ACL2.permission) && Objects.equals(this.allRepositories, ACL2.allRepositories) && Objects.equals(this.repositories, ACL2.repositories);
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.allRepositories, this.repositories);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ACL {\n");
        sb.append("    permission: ").append(this.toIndentedString(this.permission)).append("\n");
        sb.append("    allRepositories: ").append(this.toIndentedString(this.allRepositories)).append("\n");
        sb.append("    repositories: ").append(this.toIndentedString(this.repositories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

