/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.StagingLocation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StagingMetadata {
    public static final String SERIALIZED_NAME_STAGING = "staging";
    @SerializedName(value="staging")
    private StagingLocation staging;
    public static final String SERIALIZED_NAME_CHECKSUM = "checksum";
    @SerializedName(value="checksum")
    private String checksum;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "size_bytes";
    @SerializedName(value="size_bytes")
    private Long sizeBytes;
    public static final String SERIALIZED_NAME_USER_METADATA = "user_metadata";
    @SerializedName(value="user_metadata")
    private Map<String, String> userMetadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StagingMetadata staging(StagingLocation staging) {
        this.staging = staging;
        return this;
    }

    @Nonnull
    public StagingLocation getStaging() {
        return this.staging;
    }

    public void setStaging(StagingLocation staging) {
        this.staging = staging;
    }

    public StagingMetadata checksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    @Nonnull
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public StagingMetadata sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nonnull
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public StagingMetadata userMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public StagingMetadata putUserMetadataItem(String key, String userMetadataItem) {
        if (this.userMetadata == null) {
            this.userMetadata = new HashMap<String, String>();
        }
        this.userMetadata.put(key, userMetadataItem);
        return this;
    }

    @Nullable
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public StagingMetadata contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingMetadata stagingMetadata = (StagingMetadata)o;
        return Objects.equals(this.staging, stagingMetadata.staging) && Objects.equals(this.checksum, stagingMetadata.checksum) && Objects.equals(this.sizeBytes, stagingMetadata.sizeBytes) && Objects.equals(this.userMetadata, stagingMetadata.userMetadata) && Objects.equals(this.contentType, stagingMetadata.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.staging, this.checksum, this.sizeBytes, this.userMetadata, this.contentType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StagingMetadata {\n");
        sb.append("    staging: ").append(this.toIndentedString(this.staging)).append("\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    userMetadata: ").append(this.toIndentedString(this.userMetadata)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in StagingMetadata is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StagingMetadata` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        StagingLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STAGING));
        if (!jsonObj.get(SERIALIZED_NAME_CHECKSUM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checksum` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKSUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).toString()));
        }
    }

    public static StagingMetadata fromJson(String jsonString) throws IOException {
        return (StagingMetadata)JSON.getGson().fromJson(jsonString, StagingMetadata.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_STAGING);
        openapiFields.add(SERIALIZED_NAME_CHECKSUM);
        openapiFields.add(SERIALIZED_NAME_SIZE_BYTES);
        openapiFields.add(SERIALIZED_NAME_USER_METADATA);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_STAGING);
        openapiRequiredFields.add(SERIALIZED_NAME_CHECKSUM);
        openapiRequiredFields.add(SERIALIZED_NAME_SIZE_BYTES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StagingMetadata.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StagingMetadata.class));
            return new TypeAdapter<StagingMetadata>(){

                public void write(JsonWriter out, StagingMetadata value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StagingMetadata read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StagingMetadata.validateJsonObject(jsonObj);
                    return (StagingMetadata)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

