/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.AccessKeyCredentials;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Setup {
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private AccessKeyCredentials key;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Setup username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Setup key(AccessKeyCredentials key) {
        this.key = key;
        return this;
    }

    @Nullable
    public AccessKeyCredentials getKey() {
        return this.key;
    }

    public void setKey(AccessKeyCredentials key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setup setup = (Setup)o;
        return Objects.equals(this.username, setup.username) && Objects.equals(this.key, setup.key);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Setup {\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Setup is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Setup` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonNull()) {
            AccessKeyCredentials.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_KEY));
        }
    }

    public static Setup fromJson(String jsonString) throws IOException {
        return (Setup)JSON.getGson().fromJson(jsonString, Setup.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_USERNAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Setup.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Setup.class));
            return new TypeAdapter<Setup>(){

                public void write(JsonWriter out, Setup value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Setup read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Setup.validateJsonObject(jsonObj);
                    return (Setup)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

