/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Policy {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
    @SerializedName(value="creation_date")
    private Long creationDate;
    public static final String SERIALIZED_NAME_STATEMENT = "statement";
    @SerializedName(value="statement")
    private List<Statement> statement = new ArrayList<Statement>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Policy id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Policy creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Policy statement(List<Statement> statement) {
        this.statement = statement;
        return this;
    }

    public Policy addStatementItem(Statement statementItem) {
        this.statement.add(statementItem);
        return this;
    }

    @Nonnull
    public List<Statement> getStatement() {
        return this.statement;
    }

    public void setStatement(List<Statement> statement) {
        this.statement = statement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.id, policy.id) && Objects.equals(this.creationDate, policy.creationDate) && Objects.equals(this.statement, policy.statement);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.creationDate, this.statement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Policy {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    statement: ").append(this.toIndentedString(this.statement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Policy is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Policy` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATEMENT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `statement` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATEMENT).toString()));
        }
        JsonArray jsonArraystatement = jsonObj.getAsJsonArray(SERIALIZED_NAME_STATEMENT);
        for (int i = 0; i < jsonArraystatement.size(); ++i) {
            Statement.validateJsonObject(jsonArraystatement.get(i).getAsJsonObject());
        }
    }

    public static Policy fromJson(String jsonString) throws IOException {
        return (Policy)JSON.getGson().fromJson(jsonString, Policy.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_STATEMENT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATEMENT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Policy.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Policy.class));
            return new TypeAdapter<Policy>(){

                public void write(JsonWriter out, Policy value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Policy read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Policy.validateJsonObject(jsonObj);
                    return (Policy)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

