/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.OtfDiffEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OtfDiffList {
    public static final String SERIALIZED_NAME_DIFF_TYPE = "diff_type";
    @SerializedName(value="diff_type")
    private DiffTypeEnum diffType;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private List<OtfDiffEntry> results = new ArrayList<OtfDiffEntry>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OtfDiffList diffType(DiffTypeEnum diffType) {
        this.diffType = diffType;
        return this;
    }

    @Nullable
    public DiffTypeEnum getDiffType() {
        return this.diffType;
    }

    public void setDiffType(DiffTypeEnum diffType) {
        this.diffType = diffType;
    }

    public OtfDiffList results(List<OtfDiffEntry> results) {
        this.results = results;
        return this;
    }

    public OtfDiffList addResultsItem(OtfDiffEntry resultsItem) {
        this.results.add(resultsItem);
        return this;
    }

    @Nonnull
    public List<OtfDiffEntry> getResults() {
        return this.results;
    }

    public void setResults(List<OtfDiffEntry> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtfDiffList otfDiffList = (OtfDiffList)o;
        return Objects.equals((Object)this.diffType, (Object)otfDiffList.diffType) && Objects.equals(this.results, otfDiffList.results);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diffType, this.results});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtfDiffList {\n");
        sb.append("    diffType: ").append(this.toIndentedString((Object)this.diffType)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OtfDiffList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OtfDiffList` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIFF_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DIFF_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIFF_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `diff_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIFF_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULTS).toString()));
        }
        JsonArray jsonArrayresults = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESULTS);
        for (int i = 0; i < jsonArrayresults.size(); ++i) {
            OtfDiffEntry.validateJsonObject(jsonArrayresults.get(i).getAsJsonObject());
        }
    }

    public static OtfDiffList fromJson(String jsonString) throws IOException {
        return (OtfDiffList)JSON.getGson().fromJson(jsonString, OtfDiffList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DIFF_TYPE);
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RESULTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OtfDiffList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OtfDiffList.class));
            return new TypeAdapter<OtfDiffList>(){

                public void write(JsonWriter out, OtfDiffList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OtfDiffList read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OtfDiffList.validateJsonObject(jsonObj);
                    return (OtfDiffList)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DiffTypeEnum {
        CREATED("created"),
        DROPPED("dropped"),
        CHANGED("changed");

        private String value;

        private DiffTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DiffTypeEnum fromValue(String value) {
            for (DiffTypeEnum b : DiffTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DiffTypeEnum> {
            public void write(JsonWriter jsonWriter, DiffTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DiffTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DiffTypeEnum.fromValue(value);
            }
        }
    }
}

