/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.ObjectStats;
import io.lakefs.clients.api.model.Pagination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class ObjectStatsList {
    public static final String SERIALIZED_NAME_PAGINATION = "pagination";
    @SerializedName(value="pagination")
    private Pagination pagination;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private List<ObjectStats> results = new ArrayList<ObjectStats>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ObjectStatsList pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Nonnull
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public ObjectStatsList results(List<ObjectStats> results) {
        this.results = results;
        return this;
    }

    public ObjectStatsList addResultsItem(ObjectStats resultsItem) {
        this.results.add(resultsItem);
        return this;
    }

    @Nonnull
    public List<ObjectStats> getResults() {
        return this.results;
    }

    public void setResults(List<ObjectStats> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStatsList objectStatsList = (ObjectStatsList)o;
        return Objects.equals(this.pagination, objectStatsList.pagination) && Objects.equals(this.results, objectStatsList.results);
    }

    public int hashCode() {
        return Objects.hash(this.pagination, this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectStatsList {\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ObjectStatsList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ObjectStatsList` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        Pagination.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAGINATION));
        if (!jsonObj.get(SERIALIZED_NAME_RESULTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `results` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULTS).toString()));
        }
        JsonArray jsonArrayresults = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESULTS);
        for (int i = 0; i < jsonArrayresults.size(); ++i) {
            ObjectStats.validateJsonObject(jsonArrayresults.get(i).getAsJsonObject());
        }
    }

    public static ObjectStatsList fromJson(String jsonString) throws IOException {
        return (ObjectStatsList)JSON.getGson().fromJson(jsonString, ObjectStatsList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PAGINATION);
        openapiFields.add(SERIALIZED_NAME_RESULTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PAGINATION);
        openapiRequiredFields.add(SERIALIZED_NAME_RESULTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ObjectStatsList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ObjectStatsList.class));
            return new TypeAdapter<ObjectStatsList>(){

                public void write(JsonWriter out, ObjectStatsList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ObjectStatsList read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ObjectStatsList.validateJsonObject(jsonObj);
                    return (ObjectStatsList)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

