/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ObjectStats {
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_PATH_TYPE = "path_type";
    @SerializedName(value="path_type")
    private PathTypeEnum pathType;
    public static final String SERIALIZED_NAME_PHYSICAL_ADDRESS = "physical_address";
    @SerializedName(value="physical_address")
    private String physicalAddress;
    public static final String SERIALIZED_NAME_CHECKSUM = "checksum";
    @SerializedName(value="checksum")
    private String checksum;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "size_bytes";
    @SerializedName(value="size_bytes")
    private Long sizeBytes;
    public static final String SERIALIZED_NAME_MTIME = "mtime";
    @SerializedName(value="mtime")
    private Long mtime;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ObjectStats path(String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ObjectStats pathType(PathTypeEnum pathType) {
        this.pathType = pathType;
        return this;
    }

    @Nonnull
    public PathTypeEnum getPathType() {
        return this.pathType;
    }

    public void setPathType(PathTypeEnum pathType) {
        this.pathType = pathType;
    }

    public ObjectStats physicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
        return this;
    }

    @Nonnull
    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public ObjectStats checksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    @Nonnull
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public ObjectStats sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public ObjectStats mtime(Long mtime) {
        this.mtime = mtime;
        return this;
    }

    @Nonnull
    public Long getMtime() {
        return this.mtime;
    }

    public void setMtime(Long mtime) {
        this.mtime = mtime;
    }

    public ObjectStats metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ObjectStats putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ObjectStats contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStats objectStats = (ObjectStats)o;
        return Objects.equals(this.path, objectStats.path) && Objects.equals((Object)this.pathType, (Object)objectStats.pathType) && Objects.equals(this.physicalAddress, objectStats.physicalAddress) && Objects.equals(this.checksum, objectStats.checksum) && Objects.equals(this.sizeBytes, objectStats.sizeBytes) && Objects.equals(this.mtime, objectStats.mtime) && Objects.equals(this.metadata, objectStats.metadata) && Objects.equals(this.contentType, objectStats.contentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.pathType, this.physicalAddress, this.checksum, this.sizeBytes, this.mtime, this.metadata, this.contentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectStats {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathType: ").append(this.toIndentedString((Object)this.pathType)).append("\n");
        sb.append("    physicalAddress: ").append(this.toIndentedString(this.physicalAddress)).append("\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    mtime: ").append(this.toIndentedString(this.mtime)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ObjectStats is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ObjectStats` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATH_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PHYSICAL_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `physical_address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHYSICAL_ADDRESS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CHECKSUM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checksum` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKSUM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).toString()));
        }
    }

    public static ObjectStats fromJson(String jsonString) throws IOException {
        return (ObjectStats)JSON.getGson().fromJson(jsonString, ObjectStats.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_PATH_TYPE);
        openapiFields.add(SERIALIZED_NAME_PHYSICAL_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CHECKSUM);
        openapiFields.add(SERIALIZED_NAME_SIZE_BYTES);
        openapiFields.add(SERIALIZED_NAME_MTIME);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PATH);
        openapiRequiredFields.add(SERIALIZED_NAME_PATH_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_PHYSICAL_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_CHECKSUM);
        openapiRequiredFields.add(SERIALIZED_NAME_MTIME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ObjectStats.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ObjectStats.class));
            return new TypeAdapter<ObjectStats>(){

                public void write(JsonWriter out, ObjectStats value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ObjectStats read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ObjectStats.validateJsonObject(jsonObj);
                    return (ObjectStats)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PathTypeEnum {
        COMMON_PREFIX("common_prefix"),
        OBJECT("object");

        private String value;

        private PathTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PathTypeEnum fromValue(String value) {
            for (PathTypeEnum b : PathTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PathTypeEnum> {
            public void write(JsonWriter jsonWriter, PathTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PathTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PathTypeEnum.fromValue(value);
            }
        }
    }
}

