/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.ObjectError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class ObjectErrorList {
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<ObjectError> errors = new ArrayList<ObjectError>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ObjectErrorList errors(List<ObjectError> errors) {
        this.errors = errors;
        return this;
    }

    public ObjectErrorList addErrorsItem(ObjectError errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @Nonnull
    public List<ObjectError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ObjectError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectErrorList objectErrorList = (ObjectErrorList)o;
        return Objects.equals(this.errors, objectErrorList.errors);
    }

    public int hashCode() {
        return Objects.hash(this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectErrorList {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ObjectErrorList is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ObjectErrorList` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
        }
        JsonArray jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS);
        for (int i = 0; i < jsonArrayerrors.size(); ++i) {
            ObjectError.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
        }
    }

    public static ObjectErrorList fromJson(String jsonString) throws IOException {
        return (ObjectErrorList)JSON.getGson().fromJson(jsonString, ObjectErrorList.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ERRORS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ObjectErrorList.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ObjectErrorList.class));
            return new TypeAdapter<ObjectErrorList>(){

                public void write(JsonWriter out, ObjectErrorList value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ObjectErrorList read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ObjectErrorList.validateJsonObject(jsonObj);
                    return (ObjectErrorList)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

