/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.JSON;
import io.lakefs.clients.api.model.ImportPagination;
import io.lakefs.clients.api.model.RangeMetadata;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class IngestRangeCreationResponse {
    public static final String SERIALIZED_NAME_RANGE = "range";
    @SerializedName(value="range")
    private RangeMetadata range;
    public static final String SERIALIZED_NAME_PAGINATION = "pagination";
    @SerializedName(value="pagination")
    private ImportPagination pagination;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IngestRangeCreationResponse range(RangeMetadata range) {
        this.range = range;
        return this;
    }

    @Nullable
    public RangeMetadata getRange() {
        return this.range;
    }

    public void setRange(RangeMetadata range) {
        this.range = range;
    }

    public IngestRangeCreationResponse pagination(ImportPagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Nullable
    public ImportPagination getPagination() {
        return this.pagination;
    }

    public void setPagination(ImportPagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestRangeCreationResponse ingestRangeCreationResponse = (IngestRangeCreationResponse)o;
        return Objects.equals(this.range, ingestRangeCreationResponse.range) && Objects.equals(this.pagination, ingestRangeCreationResponse.pagination);
    }

    public int hashCode() {
        return Objects.hash(this.range, this.pagination);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IngestRangeCreationResponse {\n");
        sb.append("    range: ").append(this.toIndentedString(this.range)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in IngestRangeCreationResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IngestRangeCreationResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_RANGE).isJsonNull()) {
            RangeMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RANGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAGINATION) != null && !jsonObj.get(SERIALIZED_NAME_PAGINATION).isJsonNull()) {
            ImportPagination.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAGINATION));
        }
    }

    public static IngestRangeCreationResponse fromJson(String jsonString) throws IOException {
        return (IngestRangeCreationResponse)JSON.getGson().fromJson(jsonString, IngestRangeCreationResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RANGE);
        openapiFields.add(SERIALIZED_NAME_PAGINATION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IngestRangeCreationResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IngestRangeCreationResponse.class));
            return new TypeAdapter<IngestRangeCreationResponse>(){

                public void write(JsonWriter out, IngestRangeCreationResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IngestRangeCreationResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IngestRangeCreationResponse.validateJsonObject(jsonObj);
                    return (IngestRangeCreationResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

