/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import io.lakefs.clients.api.model.AccessKeyCredentials;
import io.lakefs.clients.api.model.ActionRun;
import io.lakefs.clients.api.model.ActionRunList;
import io.lakefs.clients.api.model.AuthCapabilities;
import io.lakefs.clients.api.model.AuthenticationToken;
import io.lakefs.clients.api.model.BranchCreation;
import io.lakefs.clients.api.model.BranchProtectionRule;
import io.lakefs.clients.api.model.CherryPickCreation;
import io.lakefs.clients.api.model.CommPrefsInput;
import io.lakefs.clients.api.model.Commit;
import io.lakefs.clients.api.model.CommitCreation;
import io.lakefs.clients.api.model.CommitList;
import io.lakefs.clients.api.model.Credentials;
import io.lakefs.clients.api.model.CredentialsList;
import io.lakefs.clients.api.model.CredentialsWithSecret;
import io.lakefs.clients.api.model.CurrentUser;
import io.lakefs.clients.api.model.DeleteBranchProtectionRuleRequest;
import io.lakefs.clients.api.model.Diff;
import io.lakefs.clients.api.model.DiffList;
import io.lakefs.clients.api.model.Error;
import io.lakefs.clients.api.model.FindMergeBaseResult;
import io.lakefs.clients.api.model.ForgotPasswordRequest;
import io.lakefs.clients.api.model.GarbageCollectionConfig;
import io.lakefs.clients.api.model.GarbageCollectionPrepareRequest;
import io.lakefs.clients.api.model.GarbageCollectionPrepareResponse;
import io.lakefs.clients.api.model.GarbageCollectionRule;
import io.lakefs.clients.api.model.GarbageCollectionRules;
import io.lakefs.clients.api.model.Group;
import io.lakefs.clients.api.model.GroupCreation;
import io.lakefs.clients.api.model.GroupList;
import io.lakefs.clients.api.model.HookRun;
import io.lakefs.clients.api.model.HookRunList;
import io.lakefs.clients.api.model.ImportPagination;
import io.lakefs.clients.api.model.IngestRangeCreationResponse;
import io.lakefs.clients.api.model.LoginConfig;
import io.lakefs.clients.api.model.LoginInformation;
import io.lakefs.clients.api.model.Merge;
import io.lakefs.clients.api.model.MergeResult;
import io.lakefs.clients.api.model.MergeResultSummary;
import io.lakefs.clients.api.model.MetaRangeCreation;
import io.lakefs.clients.api.model.MetaRangeCreationResponse;
import io.lakefs.clients.api.model.NextStep;
import io.lakefs.clients.api.model.ObjectCopyCreation;
import io.lakefs.clients.api.model.ObjectError;
import io.lakefs.clients.api.model.ObjectErrorList;
import io.lakefs.clients.api.model.ObjectStageCreation;
import io.lakefs.clients.api.model.ObjectStats;
import io.lakefs.clients.api.model.ObjectStatsList;
import io.lakefs.clients.api.model.OtfDiffEntry;
import io.lakefs.clients.api.model.OtfDiffList;
import io.lakefs.clients.api.model.Pagination;
import io.lakefs.clients.api.model.PathList;
import io.lakefs.clients.api.model.Policy;
import io.lakefs.clients.api.model.PolicyList;
import io.lakefs.clients.api.model.PrepareGCUncommittedRequest;
import io.lakefs.clients.api.model.PrepareGCUncommittedResponse;
import io.lakefs.clients.api.model.RangeMetadata;
import io.lakefs.clients.api.model.Ref;
import io.lakefs.clients.api.model.RefList;
import io.lakefs.clients.api.model.RefsDump;
import io.lakefs.clients.api.model.Repository;
import io.lakefs.clients.api.model.RepositoryCreation;
import io.lakefs.clients.api.model.RepositoryList;
import io.lakefs.clients.api.model.ResetCreation;
import io.lakefs.clients.api.model.RevertCreation;
import io.lakefs.clients.api.model.Setup;
import io.lakefs.clients.api.model.SetupState;
import io.lakefs.clients.api.model.StageRangeCreation;
import io.lakefs.clients.api.model.StagingLocation;
import io.lakefs.clients.api.model.StagingMetadata;
import io.lakefs.clients.api.model.Statement;
import io.lakefs.clients.api.model.StatsEvent;
import io.lakefs.clients.api.model.StatsEventsList;
import io.lakefs.clients.api.model.StorageConfig;
import io.lakefs.clients.api.model.StorageURI;
import io.lakefs.clients.api.model.TagCreation;
import io.lakefs.clients.api.model.UnderlyingObjectProperties;
import io.lakefs.clients.api.model.UpdatePasswordByToken;
import io.lakefs.clients.api.model.User;
import io.lakefs.clients.api.model.UserCreation;
import io.lakefs.clients.api.model.UserList;
import io.lakefs.clients.api.model.VersionConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import okio.ByteString;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter;
    private static LocalDateTypeAdapter localDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public JSON() {
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter(Date.class, (Object)dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, (Object)sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, (Object)byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new AccessKeyCredentials.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ActionRun.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ActionRunList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new AuthCapabilities.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new AuthenticationToken.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new BranchCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new BranchProtectionRule.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CherryPickCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CommPrefsInput.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Commit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CommitCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CommitList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Credentials.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CredentialsList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CredentialsWithSecret.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CurrentUser.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DeleteBranchProtectionRuleRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Diff.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DiffList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new FindMergeBaseResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ForgotPasswordRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GarbageCollectionConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GarbageCollectionPrepareRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GarbageCollectionPrepareResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GarbageCollectionRule.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GarbageCollectionRules.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Group.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GroupCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GroupList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new HookRun.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new HookRunList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ImportPagination.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new IngestRangeCreationResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LoginConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LoginInformation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Merge.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new MergeResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new MergeResultSummary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new MetaRangeCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new MetaRangeCreationResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NextStep.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ObjectCopyCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ObjectError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ObjectErrorList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ObjectStageCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ObjectStats.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ObjectStatsList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OtfDiffEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new OtfDiffList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Pagination.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PathList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Policy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PolicyList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PrepareGCUncommittedRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PrepareGCUncommittedResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RangeMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Ref.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RefList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RefsDump.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Repository.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RepositoryCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RepositoryList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ResetCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RevertCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Setup.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SetupState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StageRangeCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StagingLocation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StagingMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Statement.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StatsEvent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StatsEventsList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StorageConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new StorageURI.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new TagCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UnderlyingObjectProperties.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UpdatePasswordByToken.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new User.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UserCreation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new UserList.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new VersionConfig.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)gson.fromJson(jsonReader, returnType);
            }
            return (T)gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        localDateTypeAdapter = new LocalDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((Date)date, (boolean)true);
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<java.sql.Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new java.sql.Date(this.dateFormat.parse(date).getTime());
                }
                return new java.sql.Date(ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of((byte[])value).base64());
            }
        }

        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64((String)bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

