/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.AuthCapabilities;
import io.lakefs.clients.api.model.AuthenticationToken;
import io.lakefs.clients.api.model.Credentials;
import io.lakefs.clients.api.model.CredentialsList;
import io.lakefs.clients.api.model.CredentialsWithSecret;
import io.lakefs.clients.api.model.CurrentUser;
import io.lakefs.clients.api.model.ForgotPasswordRequest;
import io.lakefs.clients.api.model.Group;
import io.lakefs.clients.api.model.GroupCreation;
import io.lakefs.clients.api.model.GroupList;
import io.lakefs.clients.api.model.LoginInformation;
import io.lakefs.clients.api.model.Policy;
import io.lakefs.clients.api.model.PolicyList;
import io.lakefs.clients.api.model.UpdatePasswordByToken;
import io.lakefs.clients.api.model.User;
import io.lakefs.clients.api.model.UserCreation;
import io.lakefs.clients.api.model.UserList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call addGroupMembershipCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/members/{userId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addGroupMembershipValidateBeforeCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling addGroupMembership(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling addGroupMembership(Async)");
        }
        return this.addGroupMembershipCall(groupId, userId, _callback);
    }

    public void addGroupMembership(String groupId, String userId) throws ApiException {
        this.addGroupMembershipWithHttpInfo(groupId, userId);
    }

    public ApiResponse<Void> addGroupMembershipWithHttpInfo(String groupId, String userId) throws ApiException {
        Call localVarCall = this.addGroupMembershipValidateBeforeCall(groupId, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call addGroupMembershipAsync(String groupId, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.addGroupMembershipValidateBeforeCall(groupId, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call attachPolicyToGroupCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/policies/{policyId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call attachPolicyToGroupValidateBeforeCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling attachPolicyToGroup(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling attachPolicyToGroup(Async)");
        }
        return this.attachPolicyToGroupCall(groupId, policyId, _callback);
    }

    public void attachPolicyToGroup(String groupId, String policyId) throws ApiException {
        this.attachPolicyToGroupWithHttpInfo(groupId, policyId);
    }

    public ApiResponse<Void> attachPolicyToGroupWithHttpInfo(String groupId, String policyId) throws ApiException {
        Call localVarCall = this.attachPolicyToGroupValidateBeforeCall(groupId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call attachPolicyToGroupAsync(String groupId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.attachPolicyToGroupValidateBeforeCall(groupId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call attachPolicyToUserCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/policies/{policyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call attachPolicyToUserValidateBeforeCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling attachPolicyToUser(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling attachPolicyToUser(Async)");
        }
        return this.attachPolicyToUserCall(userId, policyId, _callback);
    }

    public void attachPolicyToUser(String userId, String policyId) throws ApiException {
        this.attachPolicyToUserWithHttpInfo(userId, policyId);
    }

    public ApiResponse<Void> attachPolicyToUserWithHttpInfo(String userId, String policyId) throws ApiException {
        Call localVarCall = this.attachPolicyToUserValidateBeforeCall(userId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call attachPolicyToUserAsync(String userId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.attachPolicyToUserValidateBeforeCall(userId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createCredentialsCall(String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCredentialsValidateBeforeCall(String userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createCredentials(Async)");
        }
        return this.createCredentialsCall(userId, _callback);
    }

    public CredentialsWithSecret createCredentials(String userId) throws ApiException {
        ApiResponse<CredentialsWithSecret> localVarResp = this.createCredentialsWithHttpInfo(userId);
        return localVarResp.getData();
    }

    public ApiResponse<CredentialsWithSecret> createCredentialsWithHttpInfo(String userId) throws ApiException {
        Call localVarCall = this.createCredentialsValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCredentialsAsync(String userId, ApiCallback<CredentialsWithSecret> _callback) throws ApiException {
        Call localVarCall = this.createCredentialsValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<CredentialsWithSecret>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createGroupCall(GroupCreation groupCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GroupCreation localVarPostBody = groupCreation;
        String localVarPath = "/auth/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupValidateBeforeCall(GroupCreation groupCreation, ApiCallback _callback) throws ApiException {
        return this.createGroupCall(groupCreation, _callback);
    }

    public Group createGroup(GroupCreation groupCreation) throws ApiException {
        ApiResponse<Group> localVarResp = this.createGroupWithHttpInfo(groupCreation);
        return localVarResp.getData();
    }

    public ApiResponse<Group> createGroupWithHttpInfo(GroupCreation groupCreation) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupCreation, null);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createGroupAsync(GroupCreation groupCreation, ApiCallback<Group> _callback) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupCreation, _callback);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createPolicyCall(Policy policy, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Policy localVarPostBody = policy;
        String localVarPath = "/auth/policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPolicyValidateBeforeCall(Policy policy, ApiCallback _callback) throws ApiException {
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling createPolicy(Async)");
        }
        return this.createPolicyCall(policy, _callback);
    }

    public Policy createPolicy(Policy policy) throws ApiException {
        ApiResponse<Policy> localVarResp = this.createPolicyWithHttpInfo(policy);
        return localVarResp.getData();
    }

    public ApiResponse<Policy> createPolicyWithHttpInfo(Policy policy) throws ApiException {
        Call localVarCall = this.createPolicyValidateBeforeCall(policy, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPolicyAsync(Policy policy, ApiCallback<Policy> _callback) throws ApiException {
        Call localVarCall = this.createPolicyValidateBeforeCall(policy, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createUserCall(UserCreation userCreation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UserCreation localVarPostBody = userCreation;
        String localVarPath = "/auth/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserValidateBeforeCall(UserCreation userCreation, ApiCallback _callback) throws ApiException {
        return this.createUserCall(userCreation, _callback);
    }

    public User createUser(UserCreation userCreation) throws ApiException {
        ApiResponse<User> localVarResp = this.createUserWithHttpInfo(userCreation);
        return localVarResp.getData();
    }

    public ApiResponse<User> createUserWithHttpInfo(UserCreation userCreation) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(userCreation, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createUserAsync(UserCreation userCreation, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(userCreation, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCredentialsCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials/{accessKeyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{accessKeyId}", this.localVarApiClient.escapeString(accessKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCredentialsValidateBeforeCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteCredentials(Async)");
        }
        if (accessKeyId == null) {
            throw new ApiException("Missing the required parameter 'accessKeyId' when calling deleteCredentials(Async)");
        }
        return this.deleteCredentialsCall(userId, accessKeyId, _callback);
    }

    public void deleteCredentials(String userId, String accessKeyId) throws ApiException {
        this.deleteCredentialsWithHttpInfo(userId, accessKeyId);
    }

    public ApiResponse<Void> deleteCredentialsWithHttpInfo(String userId, String accessKeyId) throws ApiException {
        Call localVarCall = this.deleteCredentialsValidateBeforeCall(userId, accessKeyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteCredentialsAsync(String userId, String accessKeyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteCredentialsValidateBeforeCall(userId, accessKeyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteGroupCall(String groupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(String groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroup(Async)");
        }
        return this.deleteGroupCall(groupId, _callback);
    }

    public void deleteGroup(String groupId) throws ApiException {
        this.deleteGroupWithHttpInfo(groupId);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String groupId) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupAsync(String groupId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteGroupMembershipCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/members/{userId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupMembershipValidateBeforeCall(String groupId, String userId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroupMembership(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteGroupMembership(Async)");
        }
        return this.deleteGroupMembershipCall(groupId, userId, _callback);
    }

    public void deleteGroupMembership(String groupId, String userId) throws ApiException {
        this.deleteGroupMembershipWithHttpInfo(groupId, userId);
    }

    public ApiResponse<Void> deleteGroupMembershipWithHttpInfo(String groupId, String userId) throws ApiException {
        Call localVarCall = this.deleteGroupMembershipValidateBeforeCall(groupId, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupMembershipAsync(String groupId, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupMembershipValidateBeforeCall(groupId, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deletePolicyCall(String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/policies/{policyId}".replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePolicyValidateBeforeCall(String policyId, ApiCallback _callback) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling deletePolicy(Async)");
        }
        return this.deletePolicyCall(policyId, _callback);
    }

    public void deletePolicy(String policyId) throws ApiException {
        this.deletePolicyWithHttpInfo(policyId);
    }

    public ApiResponse<Void> deletePolicyWithHttpInfo(String policyId) throws ApiException {
        Call localVarCall = this.deletePolicyValidateBeforeCall(policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deletePolicyAsync(String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deletePolicyValidateBeforeCall(policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserCall(String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(String userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteUser(Async)");
        }
        return this.deleteUserCall(userId, _callback);
    }

    public void deleteUser(String userId) throws ApiException {
        this.deleteUserWithHttpInfo(userId);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(String userId) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserAsync(String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call detachPolicyFromGroupCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/policies/{policyId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call detachPolicyFromGroupValidateBeforeCall(String groupId, String policyId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling detachPolicyFromGroup(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling detachPolicyFromGroup(Async)");
        }
        return this.detachPolicyFromGroupCall(groupId, policyId, _callback);
    }

    public void detachPolicyFromGroup(String groupId, String policyId) throws ApiException {
        this.detachPolicyFromGroupWithHttpInfo(groupId, policyId);
    }

    public ApiResponse<Void> detachPolicyFromGroupWithHttpInfo(String groupId, String policyId) throws ApiException {
        Call localVarCall = this.detachPolicyFromGroupValidateBeforeCall(groupId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call detachPolicyFromGroupAsync(String groupId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.detachPolicyFromGroupValidateBeforeCall(groupId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call detachPolicyFromUserCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/policies/{policyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call detachPolicyFromUserValidateBeforeCall(String userId, String policyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling detachPolicyFromUser(Async)");
        }
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling detachPolicyFromUser(Async)");
        }
        return this.detachPolicyFromUserCall(userId, policyId, _callback);
    }

    public void detachPolicyFromUser(String userId, String policyId) throws ApiException {
        this.detachPolicyFromUserWithHttpInfo(userId, policyId);
    }

    public ApiResponse<Void> detachPolicyFromUserWithHttpInfo(String userId, String policyId) throws ApiException {
        Call localVarCall = this.detachPolicyFromUserValidateBeforeCall(userId, policyId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call detachPolicyFromUserAsync(String userId, String policyId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.detachPolicyFromUserValidateBeforeCall(userId, policyId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call forgotPasswordCall(ForgotPasswordRequest forgotPasswordRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ForgotPasswordRequest localVarPostBody = forgotPasswordRequest;
        String localVarPath = "/auth/password/forgot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call forgotPasswordValidateBeforeCall(ForgotPasswordRequest forgotPasswordRequest, ApiCallback _callback) throws ApiException {
        if (forgotPasswordRequest == null) {
            throw new ApiException("Missing the required parameter 'forgotPasswordRequest' when calling forgotPassword(Async)");
        }
        return this.forgotPasswordCall(forgotPasswordRequest, _callback);
    }

    public void forgotPassword(ForgotPasswordRequest forgotPasswordRequest) throws ApiException {
        this.forgotPasswordWithHttpInfo(forgotPasswordRequest);
    }

    public ApiResponse<Void> forgotPasswordWithHttpInfo(ForgotPasswordRequest forgotPasswordRequest) throws ApiException {
        Call localVarCall = this.forgotPasswordValidateBeforeCall(forgotPasswordRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call forgotPasswordAsync(ForgotPasswordRequest forgotPasswordRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.forgotPasswordValidateBeforeCall(forgotPasswordRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAuthCapabilitiesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/capabilities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAuthCapabilitiesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAuthCapabilitiesCall(_callback);
    }

    public AuthCapabilities getAuthCapabilities() throws ApiException {
        ApiResponse<AuthCapabilities> localVarResp = this.getAuthCapabilitiesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<AuthCapabilities> getAuthCapabilitiesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AuthCapabilities>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAuthCapabilitiesAsync(ApiCallback<AuthCapabilities> _callback) throws ApiException {
        Call localVarCall = this.getAuthCapabilitiesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AuthCapabilities>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCredentialsCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials/{accessKeyId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString())).replace("{accessKeyId}", this.localVarApiClient.escapeString(accessKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCredentialsValidateBeforeCall(String userId, String accessKeyId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getCredentials(Async)");
        }
        if (accessKeyId == null) {
            throw new ApiException("Missing the required parameter 'accessKeyId' when calling getCredentials(Async)");
        }
        return this.getCredentialsCall(userId, accessKeyId, _callback);
    }

    public Credentials getCredentials(String userId, String accessKeyId) throws ApiException {
        ApiResponse<Credentials> localVarResp = this.getCredentialsWithHttpInfo(userId, accessKeyId);
        return localVarResp.getData();
    }

    public ApiResponse<Credentials> getCredentialsWithHttpInfo(String userId, String accessKeyId) throws ApiException {
        Call localVarCall = this.getCredentialsValidateBeforeCall(userId, accessKeyId, null);
        Type localVarReturnType = new TypeToken<Credentials>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCredentialsAsync(String userId, String accessKeyId, ApiCallback<Credentials> _callback) throws ApiException {
        Call localVarCall = this.getCredentialsValidateBeforeCall(userId, accessKeyId, _callback);
        Type localVarReturnType = new TypeToken<Credentials>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCurrentUserCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrentUserValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCurrentUserCall(_callback);
    }

    public CurrentUser getCurrentUser() throws ApiException {
        ApiResponse<CurrentUser> localVarResp = this.getCurrentUserWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<CurrentUser> getCurrentUserWithHttpInfo() throws ApiException {
        Call localVarCall = this.getCurrentUserValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CurrentUser>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrentUserAsync(ApiCallback<CurrentUser> _callback) throws ApiException {
        Call localVarCall = this.getCurrentUserValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CurrentUser>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupCall(String groupId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupValidateBeforeCall(String groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroup(Async)");
        }
        return this.getGroupCall(groupId, _callback);
    }

    public Group getGroup(String groupId) throws ApiException {
        ApiResponse<Group> localVarResp = this.getGroupWithHttpInfo(groupId);
        return localVarResp.getData();
    }

    public ApiResponse<Group> getGroupWithHttpInfo(String groupId) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupAsync(String groupId, ApiCallback<Group> _callback) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<Group>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPolicyCall(String policyId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/policies/{policyId}".replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPolicyValidateBeforeCall(String policyId, ApiCallback _callback) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling getPolicy(Async)");
        }
        return this.getPolicyCall(policyId, _callback);
    }

    public Policy getPolicy(String policyId) throws ApiException {
        ApiResponse<Policy> localVarResp = this.getPolicyWithHttpInfo(policyId);
        return localVarResp.getData();
    }

    public ApiResponse<Policy> getPolicyWithHttpInfo(String policyId) throws ApiException {
        Call localVarCall = this.getPolicyValidateBeforeCall(policyId, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPolicyAsync(String policyId, ApiCallback<Policy> _callback) throws ApiException {
        Call localVarCall = this.getPolicyValidateBeforeCall(policyId, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUserCall(String userId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserValidateBeforeCall(String userId, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling getUser(Async)");
        }
        return this.getUserCall(userId, _callback);
    }

    public User getUser(String userId) throws ApiException {
        ApiResponse<User> localVarResp = this.getUserWithHttpInfo(userId);
        return localVarResp.getData();
    }

    public ApiResponse<User> getUserWithHttpInfo(String userId) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(userId, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserAsync(String userId, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(userId, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listGroupMembersCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/members".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupMembersValidateBeforeCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling listGroupMembers(Async)");
        }
        return this.listGroupMembersCall(groupId, prefix, after, amount, _callback);
    }

    public UserList listGroupMembers(String groupId, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<UserList> localVarResp = this.listGroupMembersWithHttpInfo(groupId, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<UserList> listGroupMembersWithHttpInfo(String groupId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listGroupMembersValidateBeforeCall(groupId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listGroupMembersAsync(String groupId, String prefix, String after, Integer amount, ApiCallback<UserList> _callback) throws ApiException {
        Call localVarCall = this.listGroupMembersValidateBeforeCall(groupId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listGroupPoliciesCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups/{groupId}/policies".replace("{groupId}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupPoliciesValidateBeforeCall(String groupId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling listGroupPolicies(Async)");
        }
        return this.listGroupPoliciesCall(groupId, prefix, after, amount, _callback);
    }

    public PolicyList listGroupPolicies(String groupId, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<PolicyList> localVarResp = this.listGroupPoliciesWithHttpInfo(groupId, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<PolicyList> listGroupPoliciesWithHttpInfo(String groupId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listGroupPoliciesValidateBeforeCall(groupId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listGroupPoliciesAsync(String groupId, String prefix, String after, Integer amount, ApiCallback<PolicyList> _callback) throws ApiException {
        Call localVarCall = this.listGroupPoliciesValidateBeforeCall(groupId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listGroupsCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listGroupsValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listGroupsCall(prefix, after, amount, _callback);
    }

    public GroupList listGroups(String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<GroupList> localVarResp = this.listGroupsWithHttpInfo(prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<GroupList> listGroupsWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listGroupsValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listGroupsAsync(String prefix, String after, Integer amount, ApiCallback<GroupList> _callback) throws ApiException {
        Call localVarCall = this.listGroupsValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listPoliciesCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPoliciesValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listPoliciesCall(prefix, after, amount, _callback);
    }

    public PolicyList listPolicies(String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<PolicyList> localVarResp = this.listPoliciesWithHttpInfo(prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<PolicyList> listPoliciesWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listPoliciesValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listPoliciesAsync(String prefix, String after, Integer amount, ApiCallback<PolicyList> _callback) throws ApiException {
        Call localVarCall = this.listPoliciesValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserCredentialsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/credentials".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserCredentialsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserCredentials(Async)");
        }
        return this.listUserCredentialsCall(userId, prefix, after, amount, _callback);
    }

    public CredentialsList listUserCredentials(String userId, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<CredentialsList> localVarResp = this.listUserCredentialsWithHttpInfo(userId, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<CredentialsList> listUserCredentialsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserCredentialsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<CredentialsList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUserCredentialsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<CredentialsList> _callback) throws ApiException {
        Call localVarCall = this.listUserCredentialsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<CredentialsList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserGroupsCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/groups".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserGroupsValidateBeforeCall(String userId, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserGroups(Async)");
        }
        return this.listUserGroupsCall(userId, prefix, after, amount, _callback);
    }

    public GroupList listUserGroups(String userId, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<GroupList> localVarResp = this.listUserGroupsWithHttpInfo(userId, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<GroupList> listUserGroupsWithHttpInfo(String userId, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUserGroupsValidateBeforeCall(userId, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUserGroupsAsync(String userId, String prefix, String after, Integer amount, ApiCallback<GroupList> _callback) throws ApiException {
        Call localVarCall = this.listUserGroupsValidateBeforeCall(userId, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<GroupList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUserPoliciesCall(String userId, String prefix, String after, Integer amount, Boolean effective, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users/{userId}/policies".replace("{userId}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (effective != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("effective", effective));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUserPoliciesValidateBeforeCall(String userId, String prefix, String after, Integer amount, Boolean effective, ApiCallback _callback) throws ApiException {
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listUserPolicies(Async)");
        }
        return this.listUserPoliciesCall(userId, prefix, after, amount, effective, _callback);
    }

    public PolicyList listUserPolicies(String userId, String prefix, String after, Integer amount, Boolean effective) throws ApiException {
        ApiResponse<PolicyList> localVarResp = this.listUserPoliciesWithHttpInfo(userId, prefix, after, amount, effective);
        return localVarResp.getData();
    }

    public ApiResponse<PolicyList> listUserPoliciesWithHttpInfo(String userId, String prefix, String after, Integer amount, Boolean effective) throws ApiException {
        Call localVarCall = this.listUserPoliciesValidateBeforeCall(userId, prefix, after, amount, effective, null);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUserPoliciesAsync(String userId, String prefix, String after, Integer amount, Boolean effective, ApiCallback<PolicyList> _callback) throws ApiException {
        Call localVarCall = this.listUserPoliciesValidateBeforeCall(userId, prefix, after, amount, effective, _callback);
        Type localVarReturnType = new TypeToken<PolicyList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listUsersCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/auth/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listUsersValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        return this.listUsersCall(prefix, after, amount, _callback);
    }

    public UserList listUsers(String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<UserList> localVarResp = this.listUsersWithHttpInfo(prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<UserList> listUsersWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listUsersValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listUsersAsync(String prefix, String after, Integer amount, ApiCallback<UserList> _callback) throws ApiException {
        Call localVarCall = this.listUsersValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<UserList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call loginCall(LoginInformation loginInformation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        LoginInformation localVarPostBody = loginInformation;
        String localVarPath = "/auth/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call loginValidateBeforeCall(LoginInformation loginInformation, ApiCallback _callback) throws ApiException {
        return this.loginCall(loginInformation, _callback);
    }

    public AuthenticationToken login(LoginInformation loginInformation) throws ApiException {
        ApiResponse<AuthenticationToken> localVarResp = this.loginWithHttpInfo(loginInformation);
        return localVarResp.getData();
    }

    public ApiResponse<AuthenticationToken> loginWithHttpInfo(LoginInformation loginInformation) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(loginInformation, null);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call loginAsync(LoginInformation loginInformation, ApiCallback<AuthenticationToken> _callback) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(loginInformation, _callback);
        Type localVarReturnType = new TypeToken<AuthenticationToken>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePasswordCall(UpdatePasswordByToken updatePasswordByToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePasswordByToken localVarPostBody = updatePasswordByToken;
        String localVarPath = "/auth/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"cookie_auth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePasswordValidateBeforeCall(UpdatePasswordByToken updatePasswordByToken, ApiCallback _callback) throws ApiException {
        if (updatePasswordByToken == null) {
            throw new ApiException("Missing the required parameter 'updatePasswordByToken' when calling updatePassword(Async)");
        }
        return this.updatePasswordCall(updatePasswordByToken, _callback);
    }

    public void updatePassword(UpdatePasswordByToken updatePasswordByToken) throws ApiException {
        this.updatePasswordWithHttpInfo(updatePasswordByToken);
    }

    public ApiResponse<Void> updatePasswordWithHttpInfo(UpdatePasswordByToken updatePasswordByToken) throws ApiException {
        Call localVarCall = this.updatePasswordValidateBeforeCall(updatePasswordByToken, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updatePasswordAsync(UpdatePasswordByToken updatePasswordByToken, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updatePasswordValidateBeforeCall(updatePasswordByToken, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updatePolicyCall(String policyId, Policy policy, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Policy localVarPostBody = policy;
        String localVarPath = "/auth/policies/{policyId}".replace("{policyId}", this.localVarApiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "oidc_auth", "saml_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePolicyValidateBeforeCall(String policyId, Policy policy, ApiCallback _callback) throws ApiException {
        if (policyId == null) {
            throw new ApiException("Missing the required parameter 'policyId' when calling updatePolicy(Async)");
        }
        if (policy == null) {
            throw new ApiException("Missing the required parameter 'policy' when calling updatePolicy(Async)");
        }
        return this.updatePolicyCall(policyId, policy, _callback);
    }

    public Policy updatePolicy(String policyId, Policy policy) throws ApiException {
        ApiResponse<Policy> localVarResp = this.updatePolicyWithHttpInfo(policyId, policy);
        return localVarResp.getData();
    }

    public ApiResponse<Policy> updatePolicyWithHttpInfo(String policyId, Policy policy) throws ApiException {
        Call localVarCall = this.updatePolicyValidateBeforeCall(policyId, policy, null);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updatePolicyAsync(String policyId, Policy policy, ApiCallback<Policy> _callback) throws ApiException {
        Call localVarCall = this.updatePolicyValidateBeforeCall(policyId, policy, _callback);
        Type localVarReturnType = new TypeToken<Policy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

