/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.lakefs.clients.api.JSON;

/**
 * RangeMetadata
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class RangeMetadata {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_MIN_KEY = "min_key";
  @SerializedName(SERIALIZED_NAME_MIN_KEY)
  private String minKey;

  public static final String SERIALIZED_NAME_MAX_KEY = "max_key";
  @SerializedName(SERIALIZED_NAME_MAX_KEY)
  private String maxKey;

  public static final String SERIALIZED_NAME_COUNT = "count";
  @SerializedName(SERIALIZED_NAME_COUNT)
  private Integer count;

  public static final String SERIALIZED_NAME_ESTIMATED_SIZE = "estimated_size";
  @SerializedName(SERIALIZED_NAME_ESTIMATED_SIZE)
  private Integer estimatedSize;

  public RangeMetadata() {
  }

  public RangeMetadata id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * ID of the range.
   * @return id
  **/
  @javax.annotation.Nonnull

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public RangeMetadata minKey(String minKey) {
    
    this.minKey = minKey;
    return this;
  }

   /**
   * First key in the range.
   * @return minKey
  **/
  @javax.annotation.Nonnull

  public String getMinKey() {
    return minKey;
  }


  public void setMinKey(String minKey) {
    this.minKey = minKey;
  }


  public RangeMetadata maxKey(String maxKey) {
    
    this.maxKey = maxKey;
    return this;
  }

   /**
   * Last key in the range.
   * @return maxKey
  **/
  @javax.annotation.Nonnull

  public String getMaxKey() {
    return maxKey;
  }


  public void setMaxKey(String maxKey) {
    this.maxKey = maxKey;
  }


  public RangeMetadata count(Integer count) {
    
    this.count = count;
    return this;
  }

   /**
   * Number of records in the range.
   * @return count
  **/
  @javax.annotation.Nonnull

  public Integer getCount() {
    return count;
  }


  public void setCount(Integer count) {
    this.count = count;
  }


  public RangeMetadata estimatedSize(Integer estimatedSize) {
    
    this.estimatedSize = estimatedSize;
    return this;
  }

   /**
   * Estimated size of the range in bytes
   * @return estimatedSize
  **/
  @javax.annotation.Nonnull

  public Integer getEstimatedSize() {
    return estimatedSize;
  }


  public void setEstimatedSize(Integer estimatedSize) {
    this.estimatedSize = estimatedSize;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RangeMetadata rangeMetadata = (RangeMetadata) o;
    return Objects.equals(this.id, rangeMetadata.id) &&
        Objects.equals(this.minKey, rangeMetadata.minKey) &&
        Objects.equals(this.maxKey, rangeMetadata.maxKey) &&
        Objects.equals(this.count, rangeMetadata.count) &&
        Objects.equals(this.estimatedSize, rangeMetadata.estimatedSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, minKey, maxKey, count, estimatedSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RangeMetadata {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    minKey: ").append(toIndentedString(minKey)).append("\n");
    sb.append("    maxKey: ").append(toIndentedString(maxKey)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    estimatedSize: ").append(toIndentedString(estimatedSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("min_key");
    openapiFields.add("max_key");
    openapiFields.add("count");
    openapiFields.add("estimated_size");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("min_key");
    openapiRequiredFields.add("max_key");
    openapiRequiredFields.add("count");
    openapiRequiredFields.add("estimated_size");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RangeMetadata
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!RangeMetadata.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in RangeMetadata is not found in the empty JSON string", RangeMetadata.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!RangeMetadata.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RangeMetadata` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : RangeMetadata.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (!jsonObj.get("min_key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `min_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("min_key").toString()));
      }
      if (!jsonObj.get("max_key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `max_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("max_key").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RangeMetadata.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RangeMetadata' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RangeMetadata> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RangeMetadata.class));

       return (TypeAdapter<T>) new TypeAdapter<RangeMetadata>() {
           @Override
           public void write(JsonWriter out, RangeMetadata value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RangeMetadata read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RangeMetadata given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RangeMetadata
  * @throws IOException if the JSON string is invalid with respect to RangeMetadata
  */
  public static RangeMetadata fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RangeMetadata.class);
  }

 /**
  * Convert an instance of RangeMetadata to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

