/*
 * lakeFS API
 * lakeFS HTTP API
 *
 * The version of the OpenAPI document: 0.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.lakefs.clients.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lakefs.clients.api.model.OtfDiffEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.lakefs.clients.api.JSON;

/**
 * OtfDiffList
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class OtfDiffList {
  /**
   * Gets or Sets diffType
   */
  @JsonAdapter(DiffTypeEnum.Adapter.class)
  public enum DiffTypeEnum {
    CREATED("created"),
    
    DROPPED("dropped"),
    
    CHANGED("changed");

    private String value;

    DiffTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DiffTypeEnum fromValue(String value) {
      for (DiffTypeEnum b : DiffTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DiffTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DiffTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DiffTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DiffTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DIFF_TYPE = "diff_type";
  @SerializedName(SERIALIZED_NAME_DIFF_TYPE)
  private DiffTypeEnum diffType;

  public static final String SERIALIZED_NAME_RESULTS = "results";
  @SerializedName(SERIALIZED_NAME_RESULTS)
  private List<OtfDiffEntry> results = new ArrayList<>();

  public OtfDiffList() {
  }

  public OtfDiffList diffType(DiffTypeEnum diffType) {
    
    this.diffType = diffType;
    return this;
  }

   /**
   * Get diffType
   * @return diffType
  **/
  @javax.annotation.Nullable

  public DiffTypeEnum getDiffType() {
    return diffType;
  }


  public void setDiffType(DiffTypeEnum diffType) {
    this.diffType = diffType;
  }


  public OtfDiffList results(List<OtfDiffEntry> results) {
    
    this.results = results;
    return this;
  }

  public OtfDiffList addResultsItem(OtfDiffEntry resultsItem) {
    this.results.add(resultsItem);
    return this;
  }

   /**
   * Get results
   * @return results
  **/
  @javax.annotation.Nonnull

  public List<OtfDiffEntry> getResults() {
    return results;
  }


  public void setResults(List<OtfDiffEntry> results) {
    this.results = results;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OtfDiffList otfDiffList = (OtfDiffList) o;
    return Objects.equals(this.diffType, otfDiffList.diffType) &&
        Objects.equals(this.results, otfDiffList.results);
  }

  @Override
  public int hashCode() {
    return Objects.hash(diffType, results);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OtfDiffList {\n");
    sb.append("    diffType: ").append(toIndentedString(diffType)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("diff_type");
    openapiFields.add("results");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("results");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to OtfDiffList
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!OtfDiffList.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in OtfDiffList is not found in the empty JSON string", OtfDiffList.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!OtfDiffList.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OtfDiffList` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : OtfDiffList.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if ((jsonObj.get("diff_type") != null && !jsonObj.get("diff_type").isJsonNull()) && !jsonObj.get("diff_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `diff_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("diff_type").toString()));
      }
      // ensure the json data is an array
      if (!jsonObj.get("results").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `results` to be an array in the JSON string but got `%s`", jsonObj.get("results").toString()));
      }

      JsonArray jsonArrayresults = jsonObj.getAsJsonArray("results");
      // validate the required field `results` (array)
      for (int i = 0; i < jsonArrayresults.size(); i++) {
        OtfDiffEntry.validateJsonObject(jsonArrayresults.get(i).getAsJsonObject());
      };
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!OtfDiffList.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'OtfDiffList' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<OtfDiffList> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(OtfDiffList.class));

       return (TypeAdapter<T>) new TypeAdapter<OtfDiffList>() {
           @Override
           public void write(JsonWriter out, OtfDiffList value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public OtfDiffList read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of OtfDiffList given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of OtfDiffList
  * @throws IOException if the JSON string is invalid with respect to OtfDiffList
  */
  public static OtfDiffList fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, OtfDiffList.class);
  }

 /**
  * Convert an instance of OtfDiffList to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

