/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="location for placing an object when staging it")
public class StagingLocation {
    public static final String SERIALIZED_NAME_PHYSICAL_ADDRESS = "physical_address";
    @SerializedName(value="physical_address")
    private String physicalAddress;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_PRESIGNED_URL = "presigned_url";
    @SerializedName(value="presigned_url")
    private String presignedUrl;

    public StagingLocation physicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public StagingLocation token(String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="opaque staging token to use to link uploaded object")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public StagingLocation presignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="if presign=true is passed in the request, this field will contain a presigned URL to use when uploading")
    public String getPresignedUrl() {
        return this.presignedUrl;
    }

    public void setPresignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingLocation stagingLocation = (StagingLocation)o;
        return Objects.equals(this.physicalAddress, stagingLocation.physicalAddress) && Objects.equals(this.token, stagingLocation.token) && Objects.equals(this.presignedUrl, stagingLocation.presignedUrl);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.physicalAddress, this.token, this.presignedUrl);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StagingLocation {\n");
        sb.append("    physicalAddress: ").append(this.toIndentedString(this.physicalAddress)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    presignedUrl: ").append(this.toIndentedString(this.presignedUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

