/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthenticationToken {
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_TOKEN_EXPIRATION = "token_expiration";
    @SerializedName(value="token_expiration")
    private Long tokenExpiration;

    public AuthenticationToken token(String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="a JWT token that could be used to authenticate requests")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public AuthenticationToken tokenExpiration(Long tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unix Epoch in seconds")
    public Long getTokenExpiration() {
        return this.tokenExpiration;
    }

    public void setTokenExpiration(Long tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationToken authenticationToken = (AuthenticationToken)o;
        return Objects.equals(this.token, authenticationToken.token) && Objects.equals(this.tokenExpiration, authenticationToken.tokenExpiration);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.tokenExpiration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationToken {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenExpiration: ").append(this.toIndentedString(this.tokenExpiration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

