/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Pagination {
    public static final String SERIALIZED_NAME_HAS_MORE = "has_more";
    @SerializedName(value="has_more")
    private Boolean hasMore;
    public static final String SERIALIZED_NAME_NEXT_OFFSET = "next_offset";
    @SerializedName(value="next_offset")
    private String nextOffset;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private Integer results;
    public static final String SERIALIZED_NAME_MAX_PER_PAGE = "max_per_page";
    @SerializedName(value="max_per_page")
    private Integer maxPerPage;

    public Pagination hasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Next page is available")
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public Pagination nextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Token used to retrieve the next page")
    public String getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
    }

    public Pagination results(Integer results) {
        this.results = results;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of values found in the results")
    public Integer getResults() {
        return this.results;
    }

    public void setResults(Integer results) {
        this.results = results;
    }

    public Pagination maxPerPage(Integer maxPerPage) {
        this.maxPerPage = maxPerPage;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Maximal number of entries per page")
    public Integer getMaxPerPage() {
        return this.maxPerPage;
    }

    public void setMaxPerPage(Integer maxPerPage) {
        this.maxPerPage = maxPerPage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.hasMore, pagination.hasMore) && Objects.equals(this.nextOffset, pagination.nextOffset) && Objects.equals(this.results, pagination.results) && Objects.equals(this.maxPerPage, pagination.maxPerPage);
    }

    public int hashCode() {
        return Objects.hash(this.hasMore, this.nextOffset, this.results, this.maxPerPage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    hasMore: ").append(this.toIndentedString(this.hasMore)).append("\n");
        sb.append("    nextOffset: ").append(this.toIndentedString(this.nextOffset)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    maxPerPage: ").append(this.toIndentedString(this.maxPerPage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

