/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.Ref;
import io.lakefs.clients.api.model.RefList;
import io.lakefs.clients.api.model.TagCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TagsApi {
    private ApiClient localVarApiClient;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createTagCall(String repository, TagCreation tagCreation, ApiCallback _callback) throws ApiException {
        TagCreation localVarPostBody = tagCreation;
        String localVarPath = "/repositories/{repository}/tags".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTagValidateBeforeCall(String repository, TagCreation tagCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createTag(Async)");
        }
        if (tagCreation == null) {
            throw new ApiException("Missing the required parameter 'tagCreation' when calling createTag(Async)");
        }
        Call localVarCall = this.createTagCall(repository, tagCreation, _callback);
        return localVarCall;
    }

    public Ref createTag(String repository, TagCreation tagCreation) throws ApiException {
        ApiResponse<Ref> localVarResp = this.createTagWithHttpInfo(repository, tagCreation);
        return localVarResp.getData();
    }

    public ApiResponse<Ref> createTagWithHttpInfo(String repository, TagCreation tagCreation) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(repository, tagCreation, null);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTagAsync(String repository, TagCreation tagCreation, ApiCallback<Ref> _callback) throws ApiException {
        Call localVarCall = this.createTagValidateBeforeCall(repository, tagCreation, _callback);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTagCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/tags/{tag}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{tag\\}", this.localVarApiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTagValidateBeforeCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling deleteTag(Async)");
        }
        Call localVarCall = this.deleteTagCall(repository, tag, _callback);
        return localVarCall;
    }

    public void deleteTag(String repository, String tag) throws ApiException {
        this.deleteTagWithHttpInfo(repository, tag);
    }

    public ApiResponse<Void> deleteTagWithHttpInfo(String repository, String tag) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(repository, tag, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTagAsync(String repository, String tag, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTagValidateBeforeCall(repository, tag, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTagCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/tags/{tag}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{tag\\}", this.localVarApiClient.escapeString(tag.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTagValidateBeforeCall(String repository, String tag, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getTag(Async)");
        }
        if (tag == null) {
            throw new ApiException("Missing the required parameter 'tag' when calling getTag(Async)");
        }
        Call localVarCall = this.getTagCall(repository, tag, _callback);
        return localVarCall;
    }

    public Ref getTag(String repository, String tag) throws ApiException {
        ApiResponse<Ref> localVarResp = this.getTagWithHttpInfo(repository, tag);
        return localVarResp.getData();
    }

    public ApiResponse<Ref> getTagWithHttpInfo(String repository, String tag) throws ApiException {
        Call localVarCall = this.getTagValidateBeforeCall(repository, tag, null);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTagAsync(String repository, String tag, ApiCallback<Ref> _callback) throws ApiException {
        Call localVarCall = this.getTagValidateBeforeCall(repository, tag, _callback);
        Type localVarReturnType = new TypeToken<Ref>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTagsCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/tags".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTagsValidateBeforeCall(String repository, String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listTags(Async)");
        }
        Call localVarCall = this.listTagsCall(repository, prefix, after, amount, _callback);
        return localVarCall;
    }

    public RefList listTags(String repository, String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<RefList> localVarResp = this.listTagsWithHttpInfo(repository, prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<RefList> listTagsWithHttpInfo(String repository, String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listTagsValidateBeforeCall(repository, prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTagsAsync(String repository, String prefix, String after, Integer amount, ApiCallback<RefList> _callback) throws ApiException {
        Call localVarCall = this.listTagsValidateBeforeCall(repository, prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<RefList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

