/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.IngestRangeCreationResponse;
import io.lakefs.clients.api.model.MetaRangeCreation;
import io.lakefs.clients.api.model.MetaRangeCreationResponse;
import io.lakefs.clients.api.model.StageRangeCreation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ImportApi {
    private ApiClient localVarApiClient;

    public ImportApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImportApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createMetaRangeCall(String repository, MetaRangeCreation metaRangeCreation, ApiCallback _callback) throws ApiException {
        MetaRangeCreation localVarPostBody = metaRangeCreation;
        String localVarPath = "/repositories/{repository}/branches/metaranges".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMetaRangeValidateBeforeCall(String repository, MetaRangeCreation metaRangeCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createMetaRange(Async)");
        }
        if (metaRangeCreation == null) {
            throw new ApiException("Missing the required parameter 'metaRangeCreation' when calling createMetaRange(Async)");
        }
        Call localVarCall = this.createMetaRangeCall(repository, metaRangeCreation, _callback);
        return localVarCall;
    }

    public MetaRangeCreationResponse createMetaRange(String repository, MetaRangeCreation metaRangeCreation) throws ApiException {
        ApiResponse<MetaRangeCreationResponse> localVarResp = this.createMetaRangeWithHttpInfo(repository, metaRangeCreation);
        return localVarResp.getData();
    }

    public ApiResponse<MetaRangeCreationResponse> createMetaRangeWithHttpInfo(String repository, MetaRangeCreation metaRangeCreation) throws ApiException {
        Call localVarCall = this.createMetaRangeValidateBeforeCall(repository, metaRangeCreation, null);
        Type localVarReturnType = new TypeToken<MetaRangeCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMetaRangeAsync(String repository, MetaRangeCreation metaRangeCreation, ApiCallback<MetaRangeCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.createMetaRangeValidateBeforeCall(repository, metaRangeCreation, _callback);
        Type localVarReturnType = new TypeToken<MetaRangeCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call ingestRangeCall(String repository, StageRangeCreation stageRangeCreation, ApiCallback _callback) throws ApiException {
        StageRangeCreation localVarPostBody = stageRangeCreation;
        String localVarPath = "/repositories/{repository}/branches/ranges".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call ingestRangeValidateBeforeCall(String repository, StageRangeCreation stageRangeCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling ingestRange(Async)");
        }
        if (stageRangeCreation == null) {
            throw new ApiException("Missing the required parameter 'stageRangeCreation' when calling ingestRange(Async)");
        }
        Call localVarCall = this.ingestRangeCall(repository, stageRangeCreation, _callback);
        return localVarCall;
    }

    public IngestRangeCreationResponse ingestRange(String repository, StageRangeCreation stageRangeCreation) throws ApiException {
        ApiResponse<IngestRangeCreationResponse> localVarResp = this.ingestRangeWithHttpInfo(repository, stageRangeCreation);
        return localVarResp.getData();
    }

    public ApiResponse<IngestRangeCreationResponse> ingestRangeWithHttpInfo(String repository, StageRangeCreation stageRangeCreation) throws ApiException {
        Call localVarCall = this.ingestRangeValidateBeforeCall(repository, stageRangeCreation, null);
        Type localVarReturnType = new TypeToken<IngestRangeCreationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call ingestRangeAsync(String repository, StageRangeCreation stageRangeCreation, ApiCallback<IngestRangeCreationResponse> _callback) throws ApiException {
        Call localVarCall = this.ingestRangeValidateBeforeCall(repository, stageRangeCreation, _callback);
        Type localVarReturnType = new TypeToken<IngestRangeCreationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

