/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RangeMetadata {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_MIN_KEY = "min_key";
    @SerializedName(value="min_key")
    private String minKey;
    public static final String SERIALIZED_NAME_MAX_KEY = "max_key";
    @SerializedName(value="max_key")
    private String maxKey;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_ESTIMATED_SIZE = "estimated_size";
    @SerializedName(value="estimated_size")
    private Integer estimatedSize;

    public RangeMetadata id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="480e19972a6fbe98ab8e81ae5efdfd1a29037587e91244e87abd4adefffdb01c", required=true, value="ID of the range.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RangeMetadata minKey(String minKey) {
        this.minKey = minKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="production/collections/some/file_1.parquet", required=true, value="First key in the range.")
    public String getMinKey() {
        return this.minKey;
    }

    public void setMinKey(String minKey) {
        this.minKey = minKey;
    }

    public RangeMetadata maxKey(String maxKey) {
        this.maxKey = maxKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="production/collections/some/file_8229.parquet", required=true, value="Last key in the range.")
    public String getMaxKey() {
        return this.maxKey;
    }

    public void setMaxKey(String maxKey) {
        this.maxKey = maxKey;
    }

    public RangeMetadata count(Integer count) {
        this.count = count;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Number of records in the range.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public RangeMetadata estimatedSize(Integer estimatedSize) {
        this.estimatedSize = estimatedSize;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Estimated size of the range in bytes")
    public Integer getEstimatedSize() {
        return this.estimatedSize;
    }

    public void setEstimatedSize(Integer estimatedSize) {
        this.estimatedSize = estimatedSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeMetadata rangeMetadata = (RangeMetadata)o;
        return Objects.equals(this.id, rangeMetadata.id) && Objects.equals(this.minKey, rangeMetadata.minKey) && Objects.equals(this.maxKey, rangeMetadata.maxKey) && Objects.equals(this.count, rangeMetadata.count) && Objects.equals(this.estimatedSize, rangeMetadata.estimatedSize);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.minKey, this.maxKey, this.count, this.estimatedSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RangeMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    minKey: ").append(this.toIndentedString(this.minKey)).append("\n");
        sb.append("    maxKey: ").append(this.toIndentedString(this.maxKey)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    estimatedSize: ").append(this.toIndentedString(this.estimatedSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

