/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.BranchProtectionRule;
import io.lakefs.clients.api.model.InlineObject1;
import io.lakefs.clients.api.model.Repository;
import io.lakefs.clients.api.model.RepositoryCreation;
import io.lakefs.clients.api.model.RepositoryList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class RepositoriesApi {
    private ApiClient localVarApiClient;

    public RepositoriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RepositoriesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createBranchProtectionRuleCall(String repository, BranchProtectionRule branchProtectionRule, ApiCallback _callback) throws ApiException {
        BranchProtectionRule localVarPostBody = branchProtectionRule;
        String localVarPath = "/repositories/{repository}/branch_protection".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBranchProtectionRuleValidateBeforeCall(String repository, BranchProtectionRule branchProtectionRule, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling createBranchProtectionRule(Async)");
        }
        if (branchProtectionRule == null) {
            throw new ApiException("Missing the required parameter 'branchProtectionRule' when calling createBranchProtectionRule(Async)");
        }
        Call localVarCall = this.createBranchProtectionRuleCall(repository, branchProtectionRule, _callback);
        return localVarCall;
    }

    public void createBranchProtectionRule(String repository, BranchProtectionRule branchProtectionRule) throws ApiException {
        this.createBranchProtectionRuleWithHttpInfo(repository, branchProtectionRule);
    }

    public ApiResponse<Void> createBranchProtectionRuleWithHttpInfo(String repository, BranchProtectionRule branchProtectionRule) throws ApiException {
        Call localVarCall = this.createBranchProtectionRuleValidateBeforeCall(repository, branchProtectionRule, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBranchProtectionRuleAsync(String repository, BranchProtectionRule branchProtectionRule, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBranchProtectionRuleValidateBeforeCall(repository, branchProtectionRule, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createRepositoryCall(RepositoryCreation repositoryCreation, Boolean bare, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        RepositoryCreation localVarPostBody = repositoryCreation;
        String localVarPath = "/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (bare != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bare", bare));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createRepositoryValidateBeforeCall(RepositoryCreation repositoryCreation, Boolean bare, ApiCallback _callback) throws ApiException {
        if (repositoryCreation == null) {
            throw new ApiException("Missing the required parameter 'repositoryCreation' when calling createRepository(Async)");
        }
        Call localVarCall = this.createRepositoryCall(repositoryCreation, bare, _callback);
        return localVarCall;
    }

    public Repository createRepository(RepositoryCreation repositoryCreation, Boolean bare) throws ApiException {
        ApiResponse<Repository> localVarResp = this.createRepositoryWithHttpInfo(repositoryCreation, bare);
        return localVarResp.getData();
    }

    public ApiResponse<Repository> createRepositoryWithHttpInfo(RepositoryCreation repositoryCreation, Boolean bare) throws ApiException {
        Call localVarCall = this.createRepositoryValidateBeforeCall(repositoryCreation, bare, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createRepositoryAsync(RepositoryCreation repositoryCreation, Boolean bare, ApiCallback<Repository> _callback) throws ApiException {
        Call localVarCall = this.createRepositoryValidateBeforeCall(repositoryCreation, bare, _callback);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteBranchProtectionRuleCall(String repository, InlineObject1 inlineObject1, ApiCallback _callback) throws ApiException {
        InlineObject1 localVarPostBody = inlineObject1;
        String localVarPath = "/repositories/{repository}/branch_protection".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBranchProtectionRuleValidateBeforeCall(String repository, InlineObject1 inlineObject1, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteBranchProtectionRule(Async)");
        }
        if (inlineObject1 == null) {
            throw new ApiException("Missing the required parameter 'inlineObject1' when calling deleteBranchProtectionRule(Async)");
        }
        Call localVarCall = this.deleteBranchProtectionRuleCall(repository, inlineObject1, _callback);
        return localVarCall;
    }

    public void deleteBranchProtectionRule(String repository, InlineObject1 inlineObject1) throws ApiException {
        this.deleteBranchProtectionRuleWithHttpInfo(repository, inlineObject1);
    }

    public ApiResponse<Void> deleteBranchProtectionRuleWithHttpInfo(String repository, InlineObject1 inlineObject1) throws ApiException {
        Call localVarCall = this.deleteBranchProtectionRuleValidateBeforeCall(repository, inlineObject1, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteBranchProtectionRuleAsync(String repository, InlineObject1 inlineObject1, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBranchProtectionRuleValidateBeforeCall(repository, inlineObject1, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteRepositoryCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRepositoryValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteRepository(Async)");
        }
        Call localVarCall = this.deleteRepositoryCall(repository, _callback);
        return localVarCall;
    }

    public void deleteRepository(String repository) throws ApiException {
        this.deleteRepositoryWithHttpInfo(repository);
    }

    public ApiResponse<Void> deleteRepositoryWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.deleteRepositoryValidateBeforeCall(repository, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRepositoryAsync(String repository, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRepositoryValidateBeforeCall(repository, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getBranchProtectionRulesCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branch_protection".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBranchProtectionRulesValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getBranchProtectionRules(Async)");
        }
        Call localVarCall = this.getBranchProtectionRulesCall(repository, _callback);
        return localVarCall;
    }

    public List<BranchProtectionRule> getBranchProtectionRules(String repository) throws ApiException {
        ApiResponse<List<BranchProtectionRule>> localVarResp = this.getBranchProtectionRulesWithHttpInfo(repository);
        return localVarResp.getData();
    }

    public ApiResponse<List<BranchProtectionRule>> getBranchProtectionRulesWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.getBranchProtectionRulesValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBranchProtectionRulesAsync(String repository, ApiCallback<List<BranchProtectionRule>> _callback) throws ApiException {
        Call localVarCall = this.getBranchProtectionRulesValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<List<BranchProtectionRule>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRepositoryCall(String repository, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRepositoryValidateBeforeCall(String repository, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getRepository(Async)");
        }
        Call localVarCall = this.getRepositoryCall(repository, _callback);
        return localVarCall;
    }

    public Repository getRepository(String repository) throws ApiException {
        ApiResponse<Repository> localVarResp = this.getRepositoryWithHttpInfo(repository);
        return localVarResp.getData();
    }

    public ApiResponse<Repository> getRepositoryWithHttpInfo(String repository) throws ApiException {
        Call localVarCall = this.getRepositoryValidateBeforeCall(repository, null);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRepositoryAsync(String repository, ApiCallback<Repository> _callback) throws ApiException {
        Call localVarCall = this.getRepositoryValidateBeforeCall(repository, _callback);
        Type localVarReturnType = new TypeToken<Repository>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listRepositoriesCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token", "oidc_auth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listRepositoriesValidateBeforeCall(String prefix, String after, Integer amount, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listRepositoriesCall(prefix, after, amount, _callback);
        return localVarCall;
    }

    public RepositoryList listRepositories(String prefix, String after, Integer amount) throws ApiException {
        ApiResponse<RepositoryList> localVarResp = this.listRepositoriesWithHttpInfo(prefix, after, amount);
        return localVarResp.getData();
    }

    public ApiResponse<RepositoryList> listRepositoriesWithHttpInfo(String prefix, String after, Integer amount) throws ApiException {
        Call localVarCall = this.listRepositoriesValidateBeforeCall(prefix, after, amount, null);
        Type localVarReturnType = new TypeToken<RepositoryList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listRepositoriesAsync(String prefix, String after, Integer amount, ApiCallback<RepositoryList> _callback) throws ApiException {
        Call localVarCall = this.listRepositoriesValidateBeforeCall(prefix, after, amount, _callback);
        Type localVarReturnType = new TypeToken<RepositoryList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

