/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="location for placing an object when staging it")
public class StagingLocation {
    public static final String SERIALIZED_NAME_PHYSICAL_ADDRESS = "physical_address";
    @SerializedName(value="physical_address")
    private String physicalAddress;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;

    public StagingLocation physicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public StagingLocation token(String token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="opaque staging token to use to link uploaded object")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingLocation stagingLocation = (StagingLocation)o;
        return Objects.equals(this.physicalAddress, stagingLocation.physicalAddress) && Objects.equals(this.token, stagingLocation.token);
    }

    public int hashCode() {
        return Objects.hash(this.physicalAddress, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StagingLocation {\n");
        sb.append("    physicalAddress: ").append(this.toIndentedString(this.physicalAddress)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

