/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImportPagination {
    public static final String SERIALIZED_NAME_HAS_MORE = "has_more";
    @SerializedName(value="has_more")
    private Boolean hasMore;
    public static final String SERIALIZED_NAME_CONTINUATION_TOKEN = "continuation_token";
    @SerializedName(value="continuation_token")
    private String continuationToken;
    public static final String SERIALIZED_NAME_LAST_KEY = "last_key";
    @SerializedName(value="last_key")
    private String lastKey;

    public ImportPagination hasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="More keys to be ingested.")
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public ImportPagination continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Opaque. Token used to import the next range.")
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public ImportPagination lastKey(String lastKey) {
        this.lastKey = lastKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Last object store key that was ingested.")
    public String getLastKey() {
        return this.lastKey;
    }

    public void setLastKey(String lastKey) {
        this.lastKey = lastKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportPagination importPagination = (ImportPagination)o;
        return Objects.equals(this.hasMore, importPagination.hasMore) && Objects.equals(this.continuationToken, importPagination.continuationToken) && Objects.equals(this.lastKey, importPagination.lastKey);
    }

    public int hashCode() {
        return Objects.hash(this.hasMore, this.continuationToken, this.lastKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportPagination {\n");
        sb.append("    hasMore: ").append(this.toIndentedString(this.hasMore)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    lastKey: ").append(this.toIndentedString(this.lastKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

