/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api;

import com.google.gson.reflect.TypeToken;
import io.lakefs.clients.api.ApiCallback;
import io.lakefs.clients.api.ApiClient;
import io.lakefs.clients.api.ApiException;
import io.lakefs.clients.api.ApiResponse;
import io.lakefs.clients.api.Configuration;
import io.lakefs.clients.api.Pair;
import io.lakefs.clients.api.model.ObjectErrorList;
import io.lakefs.clients.api.model.ObjectStageCreation;
import io.lakefs.clients.api.model.ObjectStats;
import io.lakefs.clients.api.model.ObjectStatsList;
import io.lakefs.clients.api.model.PathList;
import io.lakefs.clients.api.model.UnderlyingObjectProperties;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ObjectsApi {
    private ApiClient localVarApiClient;

    public ObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ObjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteObjectCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteObjectValidateBeforeCall(String repository, String branch, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling deleteObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling deleteObject(Async)");
        }
        Call localVarCall = this.deleteObjectCall(repository, branch, path, _callback);
        return localVarCall;
    }

    public void deleteObject(String repository, String branch, String path) throws ApiException {
        this.deleteObjectWithHttpInfo(repository, branch, path);
    }

    public ApiResponse<Void> deleteObjectWithHttpInfo(String repository, String branch, String path) throws ApiException {
        Call localVarCall = this.deleteObjectValidateBeforeCall(repository, branch, path, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteObjectAsync(String repository, String branch, String path, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteObjectValidateBeforeCall(repository, branch, path, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteObjectsCall(String repository, String branch, PathList pathList, ApiCallback _callback) throws ApiException {
        PathList localVarPostBody = pathList;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects/delete".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteObjectsValidateBeforeCall(String repository, String branch, PathList pathList, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling deleteObjects(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling deleteObjects(Async)");
        }
        if (pathList == null) {
            throw new ApiException("Missing the required parameter 'pathList' when calling deleteObjects(Async)");
        }
        Call localVarCall = this.deleteObjectsCall(repository, branch, pathList, _callback);
        return localVarCall;
    }

    public ObjectErrorList deleteObjects(String repository, String branch, PathList pathList) throws ApiException {
        ApiResponse<ObjectErrorList> localVarResp = this.deleteObjectsWithHttpInfo(repository, branch, pathList);
        return localVarResp.getData();
    }

    public ApiResponse<ObjectErrorList> deleteObjectsWithHttpInfo(String repository, String branch, PathList pathList) throws ApiException {
        Call localVarCall = this.deleteObjectsValidateBeforeCall(repository, branch, pathList, null);
        Type localVarReturnType = new TypeToken<ObjectErrorList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteObjectsAsync(String repository, String branch, PathList pathList, ApiCallback<ObjectErrorList> _callback) throws ApiException {
        Call localVarCall = this.deleteObjectsValidateBeforeCall(repository, branch, pathList, _callback);
        Type localVarReturnType = new TypeToken<ObjectErrorList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getObjectCall(String repository, String ref, String path, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{ref\\}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/octet-stream", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getObjectValidateBeforeCall(String repository, String ref, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getObject(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling getObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getObject(Async)");
        }
        Call localVarCall = this.getObjectCall(repository, ref, path, _callback);
        return localVarCall;
    }

    public File getObject(String repository, String ref, String path) throws ApiException {
        ApiResponse<File> localVarResp = this.getObjectWithHttpInfo(repository, ref, path);
        return localVarResp.getData();
    }

    public ApiResponse<File> getObjectWithHttpInfo(String repository, String ref, String path) throws ApiException {
        Call localVarCall = this.getObjectValidateBeforeCall(repository, ref, path, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getObjectAsync(String repository, String ref, String path, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getObjectValidateBeforeCall(repository, ref, path, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUnderlyingPropertiesCall(String repository, String ref, String path, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects/underlyingProperties".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{ref\\}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnderlyingPropertiesValidateBeforeCall(String repository, String ref, String path, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling getUnderlyingProperties(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling getUnderlyingProperties(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling getUnderlyingProperties(Async)");
        }
        Call localVarCall = this.getUnderlyingPropertiesCall(repository, ref, path, _callback);
        return localVarCall;
    }

    public UnderlyingObjectProperties getUnderlyingProperties(String repository, String ref, String path) throws ApiException {
        ApiResponse<UnderlyingObjectProperties> localVarResp = this.getUnderlyingPropertiesWithHttpInfo(repository, ref, path);
        return localVarResp.getData();
    }

    public ApiResponse<UnderlyingObjectProperties> getUnderlyingPropertiesWithHttpInfo(String repository, String ref, String path) throws ApiException {
        Call localVarCall = this.getUnderlyingPropertiesValidateBeforeCall(repository, ref, path, null);
        Type localVarReturnType = new TypeToken<UnderlyingObjectProperties>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnderlyingPropertiesAsync(String repository, String ref, String path, ApiCallback<UnderlyingObjectProperties> _callback) throws ApiException {
        Call localVarCall = this.getUnderlyingPropertiesValidateBeforeCall(repository, ref, path, _callback);
        Type localVarReturnType = new TypeToken<UnderlyingObjectProperties>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listObjectsCall(String repository, String ref, Boolean userMetadata, String after, Integer amount, String delimiter, String prefix, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects/ls".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{ref\\}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userMetadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_metadata", userMetadata));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (amount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("amount", amount));
        }
        if (delimiter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delimiter", delimiter));
        }
        if (prefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("prefix", prefix));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listObjectsValidateBeforeCall(String repository, String ref, Boolean userMetadata, String after, Integer amount, String delimiter, String prefix, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling listObjects(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling listObjects(Async)");
        }
        Call localVarCall = this.listObjectsCall(repository, ref, userMetadata, after, amount, delimiter, prefix, _callback);
        return localVarCall;
    }

    public ObjectStatsList listObjects(String repository, String ref, Boolean userMetadata, String after, Integer amount, String delimiter, String prefix) throws ApiException {
        ApiResponse<ObjectStatsList> localVarResp = this.listObjectsWithHttpInfo(repository, ref, userMetadata, after, amount, delimiter, prefix);
        return localVarResp.getData();
    }

    public ApiResponse<ObjectStatsList> listObjectsWithHttpInfo(String repository, String ref, Boolean userMetadata, String after, Integer amount, String delimiter, String prefix) throws ApiException {
        Call localVarCall = this.listObjectsValidateBeforeCall(repository, ref, userMetadata, after, amount, delimiter, prefix, null);
        Type localVarReturnType = new TypeToken<ObjectStatsList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listObjectsAsync(String repository, String ref, Boolean userMetadata, String after, Integer amount, String delimiter, String prefix, ApiCallback<ObjectStatsList> _callback) throws ApiException {
        Call localVarCall = this.listObjectsValidateBeforeCall(repository, ref, userMetadata, after, amount, delimiter, prefix, _callback);
        Type localVarReturnType = new TypeToken<ObjectStatsList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call stageObjectCall(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        ObjectStageCreation localVarPostBody = objectStageCreation;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call stageObjectValidateBeforeCall(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling stageObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling stageObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling stageObject(Async)");
        }
        if (objectStageCreation == null) {
            throw new ApiException("Missing the required parameter 'objectStageCreation' when calling stageObject(Async)");
        }
        Call localVarCall = this.stageObjectCall(repository, branch, path, objectStageCreation, _callback);
        return localVarCall;
    }

    public ObjectStats stageObject(String repository, String branch, String path, ObjectStageCreation objectStageCreation) throws ApiException {
        ApiResponse<ObjectStats> localVarResp = this.stageObjectWithHttpInfo(repository, branch, path, objectStageCreation);
        return localVarResp.getData();
    }

    public ApiResponse<ObjectStats> stageObjectWithHttpInfo(String repository, String branch, String path, ObjectStageCreation objectStageCreation) throws ApiException {
        Call localVarCall = this.stageObjectValidateBeforeCall(repository, branch, path, objectStageCreation, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call stageObjectAsync(String repository, String branch, String path, ObjectStageCreation objectStageCreation, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.stageObjectValidateBeforeCall(repository, branch, path, objectStageCreation, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call statObjectCall(String repository, String ref, String path, Boolean userMetadata, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/refs/{ref}/objects/stat".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{ref\\}", this.localVarApiClient.escapeString(ref.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (userMetadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_metadata", userMetadata));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call statObjectValidateBeforeCall(String repository, String ref, String path, Boolean userMetadata, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling statObject(Async)");
        }
        if (ref == null) {
            throw new ApiException("Missing the required parameter 'ref' when calling statObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling statObject(Async)");
        }
        Call localVarCall = this.statObjectCall(repository, ref, path, userMetadata, _callback);
        return localVarCall;
    }

    public ObjectStats statObject(String repository, String ref, String path, Boolean userMetadata) throws ApiException {
        ApiResponse<ObjectStats> localVarResp = this.statObjectWithHttpInfo(repository, ref, path, userMetadata);
        return localVarResp.getData();
    }

    public ApiResponse<ObjectStats> statObjectWithHttpInfo(String repository, String ref, String path, Boolean userMetadata) throws ApiException {
        Call localVarCall = this.statObjectValidateBeforeCall(repository, ref, path, userMetadata, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call statObjectAsync(String repository, String ref, String path, Boolean userMetadata, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.statObjectValidateBeforeCall(repository, ref, path, userMetadata, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadObjectCall(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/repositories/{repository}/branches/{branch}/objects".replaceAll("\\{repository\\}", this.localVarApiClient.escapeString(repository.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (content != null) {
            localVarFormParams.put("content", content);
        }
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (storageClass != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("storageClass", storageClass));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basic_auth", "cookie_auth", "jwt_token"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadObjectValidateBeforeCall(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content, ApiCallback _callback) throws ApiException {
        if (repository == null) {
            throw new ApiException("Missing the required parameter 'repository' when calling uploadObject(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling uploadObject(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling uploadObject(Async)");
        }
        Call localVarCall = this.uploadObjectCall(repository, branch, path, storageClass, ifNoneMatch, content, _callback);
        return localVarCall;
    }

    public ObjectStats uploadObject(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content) throws ApiException {
        ApiResponse<ObjectStats> localVarResp = this.uploadObjectWithHttpInfo(repository, branch, path, storageClass, ifNoneMatch, content);
        return localVarResp.getData();
    }

    public ApiResponse<ObjectStats> uploadObjectWithHttpInfo(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content) throws ApiException {
        Call localVarCall = this.uploadObjectValidateBeforeCall(repository, branch, path, storageClass, ifNoneMatch, content, null);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadObjectAsync(String repository, String branch, String path, String storageClass, String ifNoneMatch, File content, ApiCallback<ObjectStats> _callback) throws ApiException {
        Call localVarCall = this.uploadObjectValidateBeforeCall(repository, branch, path, storageClass, ifNoneMatch, content, _callback);
        Type localVarReturnType = new TypeToken<ObjectStats>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

