/*
 * Decompiled with CFR 0.152.
 */
package io.lakefs.clients.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ObjectStats {
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_PATH_TYPE = "path_type";
    @SerializedName(value="path_type")
    private PathTypeEnum pathType;
    public static final String SERIALIZED_NAME_PHYSICAL_ADDRESS = "physical_address";
    @SerializedName(value="physical_address")
    private String physicalAddress;
    public static final String SERIALIZED_NAME_CHECKSUM = "checksum";
    @SerializedName(value="checksum")
    private String checksum;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "size_bytes";
    @SerializedName(value="size_bytes")
    private Long sizeBytes;
    public static final String SERIALIZED_NAME_MTIME = "mtime";
    @SerializedName(value="mtime")
    private Long mtime;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;

    public ObjectStats path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ObjectStats pathType(PathTypeEnum pathType) {
        this.pathType = pathType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PathTypeEnum getPathType() {
        return this.pathType;
    }

    public void setPathType(PathTypeEnum pathType) {
        this.pathType = pathType;
    }

    public ObjectStats physicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getPhysicalAddress() {
        return this.physicalAddress;
    }

    public void setPhysicalAddress(String physicalAddress) {
        this.physicalAddress = physicalAddress;
    }

    public ObjectStats checksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public ObjectStats sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public ObjectStats mtime(Long mtime) {
        this.mtime = mtime;
        return this;
    }

    @ApiModelProperty(required=true, value="Unix Epoch in seconds")
    public Long getMtime() {
        return this.mtime;
    }

    public void setMtime(Long mtime) {
        this.mtime = mtime;
    }

    public ObjectStats metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ObjectStats putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ObjectStats contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Object media type")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectStats objectStats = (ObjectStats)o;
        return Objects.equals(this.path, objectStats.path) && Objects.equals((Object)this.pathType, (Object)objectStats.pathType) && Objects.equals(this.physicalAddress, objectStats.physicalAddress) && Objects.equals(this.checksum, objectStats.checksum) && Objects.equals(this.sizeBytes, objectStats.sizeBytes) && Objects.equals(this.mtime, objectStats.mtime) && Objects.equals(this.metadata, objectStats.metadata) && Objects.equals(this.contentType, objectStats.contentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.pathType, this.physicalAddress, this.checksum, this.sizeBytes, this.mtime, this.metadata, this.contentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObjectStats {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathType: ").append(this.toIndentedString((Object)this.pathType)).append("\n");
        sb.append("    physicalAddress: ").append(this.toIndentedString(this.physicalAddress)).append("\n");
        sb.append("    checksum: ").append(this.toIndentedString(this.checksum)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("    mtime: ").append(this.toIndentedString(this.mtime)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PathTypeEnum {
        COMMON_PREFIX("common_prefix"),
        OBJECT("object");

        private String value;

        private PathTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PathTypeEnum fromValue(String value) {
            for (PathTypeEnum b : PathTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PathTypeEnum> {
            public void write(JsonWriter jsonWriter, PathTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PathTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PathTypeEnum.fromValue(value);
            }
        }
    }
}

